/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.entitybuilder;

import alma.acs.makesupport.AcsFileFinder;
import alma.acs.testsupport.TestLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class XsdFileFinder
extends AcsFileFinder {
    private List<String> xsdConfigFileNames;
    private boolean verbose;

    public XsdFileFinder(List<File> dirs, List<String> xsdConfigFileNames) {
        super(dirs.toArray(new File[dirs.size()]), (FilenameFilter)new XsdConfigFileNameFilter(), TestLogger.getLogger((String)"xmljbind-XsdFileFinder", (Level)Level.FINER));
        this.xsdConfigFileNames = xsdConfigFileNames;
    }

    public File resolveXsdConfigFile(String xsdConfigFileName) {
        String msg;
        File schemaConfigFile = (File)this.m_fileMap.get(xsdConfigFileName);
        if (schemaConfigFile != null && !this.xsdConfigFileNames.contains(xsdConfigFileName)) {
            msg = XsdFileFinder.class.getName() + "#resolveXsdConfigFile: requested file name matched '" + schemaConfigFile.getAbsolutePath() + "', however it was not registered as a valid config file in the constructor of this class.";
            this.m_logger.warning(msg);
            schemaConfigFile = null;
        }
        if (this.verbose) {
            msg = "requested=" + xsdConfigFileName + "; resolved=" + schemaConfigFile;
            this.m_logger.fine(msg);
        }
        return schemaConfigFile;
    }

    public File[] getAllXsdConfigFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (String xsdConfigFileName : this.xsdConfigFileNames) {
            File configFile = this.resolveXsdConfigFile(xsdConfigFileName);
            if (configFile != null) {
                files.add(configFile);
                continue;
            }
            this.m_logger.warning("Binding configuration file '" + xsdConfigFileName + "' not found. Will try to continue without.");
        }
        return files.toArray(new File[files.size()]);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static class XsdConfigFileNameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith("xml");
        }
    }
}

