/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class ParseChar
extends CellProcessorAdaptor
implements StringCellProcessor {
    public ParseChar() {
    }

    public ParseChar(DoubleCellProcessor doubleCellProcessor) {
        super(doubleCellProcessor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(Object object, CSVContext cSVContext) {
        Character c;
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (object instanceof Character) {
            c = (Character)object;
            return this.next.execute(c, cSVContext);
        } else {
            if (!(object instanceof String)) throw new SuperCSVException("Can't convert \"" + object + "\" to char. Input is not of type Character nor type String, but of type " + object.getClass().getName(), cSVContext, this);
            String string = (String)object;
            if (string.length() != 1) throw new SuperCSVException("Can't convert \"" + object + "\" to a char. It must have a length of 1 to be a valid char.", cSVContext, this);
            c = Character.valueOf(string.charAt(0));
        }
        return this.next.execute(c, cSVContext);
    }
}

