/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class DMinMax
extends CellProcessorAdaptor {
    public static final double MAXD = Double.MAX_VALUE;
    public static final double MIND = Double.MIN_VALUE;
    public static final double MAXS = 32767.0;
    public static final double MINS = -32768.0;
    public static final double MAXC = 65535.0;
    public static final double MINC = 0.0;
    public static final int MAX8bit = 255;
    public static final int MIN8bit = -128;
    protected double min;
    protected double max;

    public DMinMax(double d, double d2) {
        this.init(d, d2);
    }

    public DMinMax(double d, double d2, DoubleCellProcessor doubleCellProcessor) {
        super(doubleCellProcessor);
        this.init(d, d2);
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException {
        Double d;
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        if (object instanceof Double) {
            d = (Double)object;
        } else {
            try {
                d = Double.parseDouble(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new SuperCSVException("Parser error", cSVContext, this, numberFormatException);
            }
        }
        if (!(d >= this.min) || !(d <= this.max)) {
            throw new SuperCSVException("Entry \"" + object + "\" on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber + " is not within the numerical range " + this.min + "-" + this.max, cSVContext, this);
        }
        return this.next.execute(d, cSVContext);
    }

    private void init(double d, double d2) {
        if (d2 < d) {
            throw new SuperCSVException("max < min in the arguments " + d + " " + d2, this);
        }
        this.min = d;
        this.max = d2;
    }
}

