/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class StrRegEx
extends CellProcessorAdaptor
implements StringCellProcessor {
    private final String regex;
    private final Pattern regexPattern;
    private static final HashMap<String, String> regexMessages = new HashMap();

    public StrRegEx(String string) {
        this.handleArguments(string);
        this.regexPattern = Pattern.compile(string);
        this.regex = string;
    }

    public StrRegEx(String string, StringCellProcessor stringCellProcessor) {
        super(stringCellProcessor);
        this.handleArguments(string);
        this.regexPattern = Pattern.compile(string);
        this.regex = string;
    }

    private void handleArguments(String string) {
        if (string == null) {
            throw new NullInputException("the regular expression cannot be null", this);
        }
        if (string.equals("")) {
            throw new SuperCSVException("the regular expression  cannot be \"\" as this has no effect", this);
        }
    }

    public Object execute(Object object, CSVContext cSVContext) {
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        boolean bl = this.regexPattern.matcher((String)object).find();
        if (!bl) {
            String string = regexMessages.get(this.regex);
            if (string == null) {
                throw new SuperCSVException("Entry \"" + object + "\" does not respect the regular expression '" + this.regex + "'", cSVContext, this);
            }
            throw new SuperCSVException("Entry \"" + object + "\" does not respect the constraint '" + string + "' " + "(defined by the regular expression '" + this.regex + "')", cSVContext, this);
        }
        return this.next.execute(object, cSVContext);
    }

    public static void registerMessage(String string, String string2) {
        regexMessages.put(string, string2);
    }
}

