/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import java.util.HashSet;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.exception.NullInputException;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class Strlen
extends CellProcessorAdaptor
implements StringCellProcessor {
    protected HashSet<Integer> requiredLengths = new HashSet();

    public Strlen(int ... nArray) {
        this.addValues(nArray);
    }

    public Strlen(int n, CellProcessor cellProcessor) {
        this(new int[]{n}, cellProcessor);
    }

    public Strlen(int[] nArray, CellProcessor cellProcessor) {
        super(cellProcessor);
        this.addValues(nArray);
    }

    protected void addValues(int ... nArray) throws SuperCSVException {
        for (int n : nArray) {
            if (n < 0) {
                throw new SuperCSVException("Cannot accept length below 0", this);
            }
            this.requiredLengths.add(n);
        }
    }

    public Object execute(Object object, CSVContext cSVContext) throws SuperCSVException, ClassCastException {
        int n;
        if (object == null) {
            throw new NullInputException("Input cannot be null on line " + cSVContext.lineNumber + " at column " + cSVContext.columnNumber, cSVContext, this);
        }
        String string = object == null ? null : object.toString();
        int n2 = n = string == null ? 0 : string.length();
        if (!this.requiredLengths.contains(n)) {
            throw new SuperCSVException("Entry \"" + object + "\" is not of any of " + "the required lengths " + this.printRequiredLengths(), cSVContext, this);
        }
        return this.next.execute(object, cSVContext);
    }

    private String printRequiredLengths() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        String string2 = ", ";
        for (int n : this.requiredLengths) {
            stringBuilder.append(string);
            stringBuilder.append(n);
            string = string2;
        }
        return stringBuilder.toString();
    }
}

