/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.List;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.io.ITokenizer;
import org.supercsv.io.PARSERSTATE;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CSVContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer
implements ITokenizer {
    CsvPreference preferences;
    LineNumberReader lnr;
    StringBuilder sb = null;

    public Tokenizer(Reader reader, CsvPreference csvPreference) {
        this.preferences = csvPreference;
        this.lnr = new LineNumberReader(reader);
        this.sb = new StringBuilder(500);
    }

    private static void addSpaces(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
    }

    @Override
    public void close() throws IOException {
        this.lnr.close();
    }

    @Override
    public int getLineNumber() {
        return this.lnr.getLineNumber();
    }

    @Override
    public boolean readStringList(List<String> list) throws IOException {
        String string;
        list.clear();
        PARSERSTATE pARSERSTATE = PARSERSTATE.NORMAL;
        int n = this.preferences.getQuoteChar();
        int n2 = this.preferences.getDelimiterChar();
        do {
            if ((string = this.lnr.readLine()) != null) continue;
            return false;
        } while (string.length() == 0);
        string = string + "\n";
        this.sb.delete(0, this.sb.length());
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        while (true) {
            char c = string.charAt(n3);
            switch (pARSERSTATE) {
                case NORMAL: {
                    if (c == n2) {
                        list.add(this.sb.toString());
                        this.sb.delete(0, this.sb.length());
                        n5 = 0;
                        break;
                    }
                    if (c == ' ') {
                        if (this.sb.length() <= 0) break;
                        ++n5;
                        break;
                    }
                    if (c == '\n') {
                        list.add(this.sb.toString());
                        return true;
                    }
                    if (c == n) {
                        if (this.sb.length() == 0) {
                            pARSERSTATE = PARSERSTATE.QUOTESCOPE;
                            n4 = this.getLineNumber();
                            break;
                        }
                        if (string.charAt(n3 + 1) == n && this.sb.length() > 0) {
                            Tokenizer.addSpaces(this.sb, n5);
                            n5 = 0;
                            this.sb.append(c);
                            ++n3;
                            break;
                        }
                        if (string.charAt(n3 + 1) == n) break;
                        pARSERSTATE = PARSERSTATE.QUOTESCOPE;
                        n4 = this.getLineNumber();
                        Tokenizer.addSpaces(this.sb, n5);
                        n5 = 0;
                        break;
                    }
                    Tokenizer.addSpaces(this.sb, n5);
                    n5 = 0;
                    this.sb.append(c);
                    break;
                }
                case QUOTESCOPE: {
                    if (c == '\n') {
                        this.sb.append('\n');
                        n3 = -1;
                        string = this.lnr.readLine();
                        if (string == null) {
                            throw new SuperCSVException("File ended unexpectedly while reading a quoted cell starting on line: " + n4, new CSVContext(n4, 0));
                        }
                        string = string + '\n';
                        break;
                    }
                    if (c == n) {
                        if (string.charAt(n3 + 1) == n) {
                            this.sb.append(c);
                            ++n3;
                            break;
                        }
                        pARSERSTATE = PARSERSTATE.NORMAL;
                        break;
                    }
                    this.sb.append(c);
                    break;
                }
                default: {
                    throw new RuntimeException("this can never happen!");
                }
            }
            ++n3;
        }
    }
}

