/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject.data;

import alma.entity.xmlbinding.obsproject.CalibrationTargetParametersT;
import alma.entity.xmlbinding.obsproject.CalibrationTargetPropertiesT;
import alma.entity.xmlbinding.obsproject.types.CalibrationTargetParametersTIntendedUseType;
import alma.entity.xmlbinding.obsproject.types.CalibrationTargetParametersTSolarSystemObjectType;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.VelocityT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.CompositionChild;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetProperties;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CalibrationTargetParametersData
extends BusinessObject
implements IBusinessObject,
CompositionChild {
    public static final String INTENDEDUSE_AMPLITUDE = CalibrationTargetParametersTIntendedUseType.AMPLITUDE.toString();
    public static final String INTENDEDUSE_ATMOSPHERIC = CalibrationTargetParametersTIntendedUseType.ATMOSPHERIC.toString();
    public static final String INTENDEDUSE_BANDPASS = CalibrationTargetParametersTIntendedUseType.BANDPASS.toString();
    public static final String INTENDEDUSE_PHASE = CalibrationTargetParametersTIntendedUseType.PHASE.toString();
    public static final String INTENDEDUSE_POINTING = CalibrationTargetParametersTIntendedUseType.POINTING.toString();
    public static final String INTENDEDUSE_FOCUS = CalibrationTargetParametersTIntendedUseType.FOCUS.toString();
    public static final String INTENDEDUSE_POLARIZATION = CalibrationTargetParametersTIntendedUseType.POLARIZATION.toString();
    public static final String INTENDEDUSE_DELAY = CalibrationTargetParametersTIntendedUseType.DELAY.toString();
    public static final String INTENDEDUSE_SIDEBANDRATIO = CalibrationTargetParametersTIntendedUseType.SIDEBANDRATIO.toString();
    public static final String INTENDEDUSE_CHECKSOURCE = CalibrationTargetParametersTIntendedUseType.CHECKSOURCE.toString();
    public static final String SOLARSYSTEMOBJECT_MERCURY = CalibrationTargetParametersTSolarSystemObjectType.MERCURY.toString();
    public static final String SOLARSYSTEMOBJECT_VENUS = CalibrationTargetParametersTSolarSystemObjectType.VENUS.toString();
    public static final String SOLARSYSTEMOBJECT_MOON = CalibrationTargetParametersTSolarSystemObjectType.MOON.toString();
    public static final String SOLARSYSTEMOBJECT_MARS = CalibrationTargetParametersTSolarSystemObjectType.MARS.toString();
    public static final String SOLARSYSTEMOBJECT_JUPITER = CalibrationTargetParametersTSolarSystemObjectType.JUPITER.toString();
    public static final String SOLARSYSTEMOBJECT_SATURN = CalibrationTargetParametersTSolarSystemObjectType.SATURN.toString();
    public static final String SOLARSYSTEMOBJECT_URANUS = CalibrationTargetParametersTSolarSystemObjectType.URANUS.toString();
    public static final String SOLARSYSTEMOBJECT_NEPTUNE = CalibrationTargetParametersTSolarSystemObjectType.NEPTUNE.toString();
    public static final String SOLARSYSTEMOBJECT_PLUTO = CalibrationTargetParametersTSolarSystemObjectType.PLUTO.toString();
    public static final String SOLARSYSTEMOBJECT_SUN = CalibrationTargetParametersTSolarSystemObjectType.SUN.toString();
    public static final String SOLARSYSTEMOBJECT_GANYMEDE = CalibrationTargetParametersTSolarSystemObjectType.GANYMEDE.toString();
    public static final String SOLARSYSTEMOBJECT_EUROPA = CalibrationTargetParametersTSolarSystemObjectType.EUROPA.toString();
    public static final String SOLARSYSTEMOBJECT_CALLISTO = CalibrationTargetParametersTSolarSystemObjectType.CALLISTO.toString();
    public static final String SOLARSYSTEMOBJECT_IO = CalibrationTargetParametersTSolarSystemObjectType.IO.toString();
    public static final String SOLARSYSTEMOBJECT_TITAN = CalibrationTargetParametersTSolarSystemObjectType.TITAN.toString();
    public static final String SOLARSYSTEMOBJECT_CERES = CalibrationTargetParametersTSolarSystemObjectType.CERES.toString();
    public static final String SOLARSYSTEMOBJECT_PALLAS = CalibrationTargetParametersTSolarSystemObjectType.PALLAS.toString();
    public static final String SOLARSYSTEMOBJECT_JUNO = CalibrationTargetParametersTSolarSystemObjectType.JUNO.toString();
    public static final String SOLARSYSTEMOBJECT_VESTA = CalibrationTargetParametersTSolarSystemObjectType.VESTA.toString();
    public static final String SOLARSYSTEMOBJECT_EPHEMERIS = CalibrationTargetParametersTSolarSystemObjectType.EPHEMERIS.toString();
    public static final String SOLARSYSTEMOBJECT_UNSPECIFIED = CalibrationTargetParametersTSolarSystemObjectType.UNSPECIFIED.toString();
    protected static String[] knownIntendedUseList = new String[]{INTENDEDUSE_AMPLITUDE, INTENDEDUSE_ATMOSPHERIC, INTENDEDUSE_BANDPASS, INTENDEDUSE_PHASE, INTENDEDUSE_POINTING, INTENDEDUSE_FOCUS, INTENDEDUSE_POLARIZATION, INTENDEDUSE_DELAY, INTENDEDUSE_SIDEBANDRATIO, INTENDEDUSE_CHECKSOURCE};
    protected static String[] knownSolarSystemObjectList = new String[]{SOLARSYSTEMOBJECT_MERCURY, SOLARSYSTEMOBJECT_VENUS, SOLARSYSTEMOBJECT_MOON, SOLARSYSTEMOBJECT_MARS, SOLARSYSTEMOBJECT_JUPITER, SOLARSYSTEMOBJECT_SATURN, SOLARSYSTEMOBJECT_URANUS, SOLARSYSTEMOBJECT_NEPTUNE, SOLARSYSTEMOBJECT_PLUTO, SOLARSYSTEMOBJECT_SUN, SOLARSYSTEMOBJECT_GANYMEDE, SOLARSYSTEMOBJECT_EUROPA, SOLARSYSTEMOBJECT_CALLISTO, SOLARSYSTEMOBJECT_IO, SOLARSYSTEMOBJECT_TITAN, SOLARSYSTEMOBJECT_CERES, SOLARSYSTEMOBJECT_PALLAS, SOLARSYSTEMOBJECT_JUNO, SOLARSYSTEMOBJECT_VESTA, SOLARSYSTEMOBJECT_EPHEMERIS, SOLARSYSTEMOBJECT_UNSPECIFIED};
    private static List<Class> parentTypes = Arrays.asList(CalibrationSetupParameters.class);
    private SkyCoordinates boSourceCoordinates = null;
    private Velocity boSourceVelocity = null;
    private ArrayList<CalibrationTargetProperties> boCalibrationTargetProperties = new ArrayList();

    protected CalibrationTargetParametersData(CalibrationTargetParametersT castorObject) {
        super(castorObject);
    }

    public static CalibrationTargetParametersT testsupport_createCalibrationTargetParametersT() {
        return CalibrationTargetParameters.createCalibrationTargetParametersT();
    }

    protected static final CalibrationTargetParametersT createCalibrationTargetParametersT() {
        CalibrationTargetParametersT ret = new CalibrationTargetParametersT();
        CalibrationTargetParameters.patchCalibrationTargetParametersT((CalibrationTargetParametersT)ret);
        return ret;
    }

    protected static final void patchCalibrationTargetParametersT(CalibrationTargetParametersT castorObject) {
        castorObject.setIndex(0);
        castorObject.setNonSiderealMotion(false);
    }

    private static final CalibrationTargetParameters createUnitializedCalibrationTargetParameters() {
        CalibrationTargetParametersT so = CalibrationTargetParameters.createCalibrationTargetParametersT();
        CalibrationTargetParameters ret = new CalibrationTargetParameters(so);
        return ret;
    }

    public static CalibrationTargetParameters createCalibrationTargetParameters() {
        CalibrationTargetParametersT so = CalibrationTargetParameters.createCalibrationTargetParametersT();
        CalibrationTargetParameters ret = new CalibrationTargetParameters(so);
        ret.initAsNew();
        return ret;
    }

    public void setSourceName(String newValue) {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        castorObject.setSourceName(newValue);
        String propName = "alma.obsprep.bo.obsproject.CalibrationTargetParameters.sourceName";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.CalibrationTargetParameters.sourceName", propValue);
    }

    public String gettrueSourceName() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        String ret = castorObject.getSourceName();
        return ret;
    }

    public String getSourceName() {
        String ret = this.gettrueSourceName();
        if (ret == null) {
            ret = "";
            this.setSourceName(ret);
        }
        return ret;
    }

    private void wrapSourceCoordinates() {
        SkyCoordinatesT subSo = this.getCastorObject().getSourceCoordinates();
        if (subSo != null) {
            SkyCoordinates subBo;
            this.boSourceCoordinates = subBo = new SkyCoordinates(subSo);
        }
    }

    public void setSourceCoordinates(SkyCoordinates newValue) {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        SkyCoordinatesT subCastorObject = newValue.getCastorObject();
        castorObject.setSourceCoordinates(subCastorObject);
        this.boSourceCoordinates = newValue;
        String propName = "alma.obsprep.bo.obsproject.CalibrationTargetParameters.sourceCoordinates";
        SkyCoordinates propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.CalibrationTargetParameters.sourceCoordinates", propValue);
    }

    public SkyCoordinates gettrueSourceCoordinates() {
        SkyCoordinates ret = this.boSourceCoordinates;
        return ret;
    }

    public SkyCoordinates getSourceCoordinates() {
        SkyCoordinates ret = this.gettrueSourceCoordinates();
        if (ret == null) {
            ret = SkyCoordinates.createSkyCoordinates();
            this.setSourceCoordinates(ret);
        }
        return ret;
    }

    private void wrapSourceVelocity() {
        VelocityT subSo = this.getCastorObject().getSourceVelocity();
        if (subSo != null) {
            Velocity subBo;
            this.boSourceVelocity = subBo = new Velocity(subSo);
        }
    }

    public void setSourceVelocity(Velocity newValue) {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        VelocityT subCastorObject = newValue.getCastorObject();
        castorObject.setSourceVelocity(subCastorObject);
        this.boSourceVelocity = newValue;
        String propName = "alma.obsprep.bo.obsproject.CalibrationTargetParameters.sourceVelocity";
        Velocity propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.CalibrationTargetParameters.sourceVelocity", propValue);
    }

    public Velocity gettrueSourceVelocity() {
        Velocity ret = this.boSourceVelocity;
        return ret;
    }

    public Velocity getSourceVelocity() {
        Velocity ret = this.gettrueSourceVelocity();
        if (ret == null) {
            ret = Velocity.createVelocity();
            this.setSourceVelocity(ret);
        }
        return ret;
    }

    public void setIndex(int newValue) {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        castorObject.setIndex(newValue);
        String propName = "alma.obsprep.bo.obsproject.CalibrationTargetParameters.index";
        Integer propValue = new Integer(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.CalibrationTargetParameters.index", propValue);
    }

    public int gettrueIndex() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        int ret = castorObject.getIndex();
        return ret;
    }

    public int getIndex() {
        int ret = this.gettrueIndex();
        return ret;
    }

    public boolean hasIndex() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasIndex();
        return ret;
    }

    public void setIntendedUse(String newValue) throws IllegalArgumentException {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        CalibrationTargetParametersTIntendedUseType castorEnumElement = CalibrationTargetParametersTIntendedUseType.valueOf(newValue);
        castorObject.setIntendedUse(castorEnumElement);
        String propName = "alma.obsprep.bo.obsproject.CalibrationTargetParameters.intendedUse";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.CalibrationTargetParameters.intendedUse", propValue);
    }

    public String getIntendedUse() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        CalibrationTargetParametersTIntendedUseType value = castorObject.getIntendedUse();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownIntendedUseList() {
        return knownIntendedUseList;
    }

    public void setSolarSystemObject(String newValue) throws IllegalArgumentException {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        CalibrationTargetParametersTSolarSystemObjectType castorEnumElement = CalibrationTargetParametersTSolarSystemObjectType.valueOf(newValue);
        castorObject.setSolarSystemObject(castorEnumElement);
        String propName = "alma.obsprep.bo.obsproject.CalibrationTargetParameters.solarSystemObject";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.CalibrationTargetParameters.solarSystemObject", propValue);
    }

    public String getSolarSystemObject() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        CalibrationTargetParametersTSolarSystemObjectType value = castorObject.getSolarSystemObject();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownSolarSystemObjectList() {
        return knownSolarSystemObjectList;
    }

    public void setNonSiderealMotion(boolean newValue) {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        castorObject.setNonSiderealMotion(newValue);
        String propName = "alma.obsprep.bo.obsproject.CalibrationTargetParameters.nonSiderealMotion";
        Boolean propValue = new Boolean(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.CalibrationTargetParameters.nonSiderealMotion", propValue);
    }

    public boolean gettrueNonSiderealMotion() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        boolean ret = castorObject.getNonSiderealMotion();
        return ret;
    }

    public boolean getNonSiderealMotion() {
        boolean ret = this.gettrueNonSiderealMotion();
        return ret;
    }

    public boolean hasNonSiderealMotion() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasNonSiderealMotion();
        return ret;
    }

    public void setCalibrationTargetProperties(CalibrationTargetProperties[] bos) {
        this.clearCalibrationTargetProperties();
        for (int i = 0; i < bos.length; ++i) {
            this.addCalibrationTargetProperties(i, bos[i]);
        }
    }

    public CalibrationTargetProperties[] gettrueCalibrationTargetProperties() {
        return this.getCalibrationTargetProperties();
    }

    public CalibrationTargetProperties[] getCalibrationTargetProperties() {
        int size = this.getCalibrationTargetPropertiesCount();
        CalibrationTargetProperties[] ret = new CalibrationTargetProperties[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getCalibrationTargetProperties(i);
        }
        return ret;
    }

    public void addCalibrationTargetProperties(CalibrationTargetProperties bo) {
        this.addCalibrationTargetProperties(this.getCalibrationTargetPropertiesCount(), bo);
    }

    public void clearCalibrationTargetProperties() {
        int size = this.getCalibrationTargetPropertiesCount();
        for (int i = 0; i < size; ++i) {
            CalibrationTargetProperties first = this.getCalibrationTargetProperties(0);
            this.removeCalibrationTargetProperties(first);
        }
    }

    public void addCalibrationTargetProperties(int index, CalibrationTargetProperties bo) throws IndexOutOfBoundsException {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        CalibrationTargetPropertiesT subCastorObject = bo.getCastorObject();
        castorObject.addCalibrationTargetProperties(index, subCastorObject);
        this.boCalibrationTargetProperties.add(index, bo);
        Referring.By by = Referring.By.UmlComposition;
        bo.addedTo((IBusinessObject)this, by, index);
    }

    public boolean removeCalibrationTargetProperties(CalibrationTargetProperties bo) {
        boolean ok = false;
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        CalibrationTargetPropertiesT subCastorObject = bo.getCastorObject();
        ok = castorObject.removeCalibrationTargetProperties(subCastorObject);
        this.boCalibrationTargetProperties.remove(bo);
        if (ok) {
            Referring.By by = Referring.By.UmlComposition;
            bo.removedFrom((IBusinessObject)this, by);
        }
        return ok;
    }

    public CalibrationTargetProperties getCalibrationTargetProperties(int index) throws IndexOutOfBoundsException {
        CalibrationTargetProperties ret = this.boCalibrationTargetProperties.get(index);
        return ret;
    }

    public int getCalibrationTargetPropertiesCount() {
        CalibrationTargetParametersT castorObject = this.getCastorObject();
        return castorObject.getCalibrationTargetPropertiesCount();
    }

    private void wrapCalibrationTargetProperties() {
        CalibrationTargetPropertiesT[] all;
        for (CalibrationTargetPropertiesT so : all = this.getCastorObject().getCalibrationTargetProperties()) {
            CalibrationTargetProperties bo = new CalibrationTargetProperties(so);
            this.boCalibrationTargetProperties.add(bo);
        }
    }

    @Override
    public CalibrationTargetParametersT getCastorObject() {
        return (CalibrationTargetParametersT)this.storageObject;
    }

    public CalibrationTargetParameters deepCopy() throws CopyException {
        return (CalibrationTargetParameters)super.deepCopy();
    }

    protected CalibrationTargetParameters invokeCreateUnitialized() throws CopyException {
        return CalibrationTargetParametersData.createUnitializedCalibrationTargetParameters();
    }

    @Override
    protected void initAttribsAndPartsFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(original, copier);
        CalibrationTargetParametersData orig = (CalibrationTargetParametersData)original;
        if (orig.gettrueSourceName() != null) {
            this.setSourceName(orig.gettrueSourceName());
        }
        if (orig.gettrueSourceCoordinates() != null) {
            this.setSourceCoordinates((SkyCoordinates)copier.cpAttr((BusinessObject)orig.gettrueSourceCoordinates()));
        }
        if (orig.gettrueSourceVelocity() != null) {
            this.setSourceVelocity((Velocity)copier.cpAttr((BusinessObject)orig.gettrueSourceVelocity()));
        }
        if (orig.hasIndex()) {
            this.setIndex(orig.getIndex());
        }
        if (orig.getIntendedUse() != null) {
            this.setIntendedUse(orig.getIntendedUse());
        }
        if (orig.getSolarSystemObject() != null) {
            this.setSolarSystemObject(orig.getSolarSystemObject());
        }
        if (orig.hasNonSiderealMotion()) {
            this.setNonSiderealMotion(orig.getNonSiderealMotion());
        }
        try {
            CalibrationTargetProperties[] theCalibrationTargetPropertiess = orig.gettrueCalibrationTargetProperties();
            if (theCalibrationTargetPropertiess != null) {
                this.clearCalibrationTargetProperties();
                for (int i = 0; i < theCalibrationTargetPropertiess.length; ++i) {
                    this.addCalibrationTargetProperties((CalibrationTargetProperties)copier.cpPart((BusinessObject)theCalibrationTargetPropertiess[i]));
                }
            }
        }
        catch (Exception exc) {
            throw new CopyException("Failed to copy CalibrationTargetProperties", (Throwable)exc);
        }
    }

    @Override
    protected void initEntityReferencesFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(original, copier);
        CalibrationTargetParametersData orig = (CalibrationTargetParametersData)original;
    }

    @Override
    public void wrapObjects(ReferenceablesMap referencedObjects, List<ReferenceableProxy<? extends IBusinessObject>> referrers) {
        super.wrapObjects(referencedObjects, referrers);
        this.wrapSourceCoordinates();
        this.wrapSourceVelocity();
        this.wrapCalibrationTargetProperties();
    }

    @Override
    public List<IBusinessObject> referencedBOs(Referring.By ... bys) {
        List<IBusinessObject> r = super.referencedBOs(bys);
        block5: for (Referring.By by : bys) {
            switch (by) {
                case UmlComposition: {
                    this.addToCollection(r, this.gettrueCalibrationTargetProperties());
                    continue block5;
                }
                case UmlUnidir: {
                    continue block5;
                }
                case UmlAttribution: {
                    this.addToCollection(r, this.gettrueSourceCoordinates());
                    this.addToCollection(r, this.gettrueSourceVelocity());
                }
            }
        }
        return r;
    }

    @Override
    public List<Class> getParentTypes() {
        return parentTypes;
    }

    @Override
    public void addToParent(IBusinessObject newParent) {
        if (newParent == null) {
            return;
        }
        if (!(newParent instanceof CalibrationSetupParameters)) {
            throw new ClassCastException("not a legal parent type: " + newParent.getClass());
        }
        CalibrationSetupParameters p = (CalibrationSetupParameters)newParent;
        p.addCalibrationTargetParameters((CalibrationTargetParameters)this);
    }

    @Override
    public void removeFromParent() {
        BusinessObject oldParent = this.getParent();
        if (oldParent == null) {
            return;
        }
        if (oldParent instanceof CalibrationSetupParameters) {
            CalibrationSetupParameters p = (CalibrationSetupParameters)oldParent;
            p.removeCalibrationTargetParameters((CalibrationTargetParameters)this);
        }
    }
}

