/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.astrogrid.AcrConnection;
import uk.ac.starlink.astrogrid.AcrLeaf;
import uk.ac.starlink.astrogrid.AcrNode;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.ErrorLeaf;
import uk.ac.starlink.connect.Leaf;
import uk.ac.starlink.connect.Node;
import uk.ac.starlink.util.DataSource;

class AcrBranch
extends AcrNode
implements Branch {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.astrogrid");
    private final AcrConnection connection_;
    private Node[] children_;

    public AcrBranch(AcrConnection connection, String uri, String name, AcrBranch parent) {
        super(connection, uri, name, parent);
        this.connection_ = connection;
    }

    public Node[] getChildren() {
        if (this.connection_.getCacheDirectories()) {
            if (this.children_ == null) {
                this.children_ = this.readChildren();
            }
            return this.children_;
        }
        return this.readChildren();
    }

    private Node[] readChildren() {
        try {
            return this.getAcrChildNodes();
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Error connecting to ACR", e);
            return new Node[]{new ErrorLeaf((Branch)this, (Throwable)e)};
        }
    }

    private Node[] getAcrChildNodes() throws IOException {
        Object[] childInfos = (Object[])this.executeMyspace("listNodeInformation", new Object[]{this.uri_});
        int nChild = childInfos.length;
        ArrayList<AcrNode> childNodeList = new ArrayList<AcrNode>();
        for (int i = 0; i < nChild; ++i) {
            boolean isFolder;
            Map childInfo = (Map)childInfos[i];
            String childUri = (String)childInfo.get("id");
            String childName = (String)childInfo.get("name");
            boolean isFile = (Boolean)childInfo.get("file");
            if (isFile != (isFolder = ((Boolean)childInfo.get("folder")).booleanValue())) {
                if (isFolder) {
                    childNodeList.add(new AcrBranch(this.connection_, childUri, childName, this));
                    continue;
                }
                if (!isFile) continue;
                childNodeList.add(new AcrLeaf(this.connection_, childUri, childName, this));
                continue;
            }
            logger_.warning(childUri + ": is it a file or is it a folder??" + " - skipping");
        }
        return childNodeList.toArray(new Node[0]);
    }

    public Node createNode(String name) {
        Node[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].getName().equals(name)) continue;
            return children[i];
        }
        return new PotentialChildLeaf(name);
    }

    private class PotentialChildLeaf
    implements Leaf {
        private final String name_;
        private final AcrBranch parent_;
        private String childUri_;

        PotentialChildLeaf(String name) {
            this.name_ = name;
            this.parent_ = AcrBranch.this;
        }

        public String getName() {
            return this.name_;
        }

        public Branch getParent() {
            return this.parent_;
        }

        public DataSource getDataSource() throws IOException {
            throw new FileNotFoundException("No such node " + this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream getOutputStream() throws IOException {
            PotentialChildLeaf potentialChildLeaf = this;
            synchronized (potentialChildLeaf) {
                if (this.childUri_ == null) {
                    this.childUri_ = (String)AcrBranch.this.executeMyspace("createChildFile", new Object[]{this.parent_.uri_, this.name_});
                }
            }
            return AcrBranch.this.connection_.getOutputStream(this.childUri_);
        }

        public String toString() {
            return this.childUri_ == null ? this.parent_.toString() + "/" + this.name_ : this.childUri_;
        }
    }
}

