/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen;

import alma.tools.idlgen.JacorbVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jacorb.idl.AcsInterfacePrinter;
import org.jacorb.idl.AcsStructPrinter;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Interface;
import org.jacorb.idl.StructType;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;

public class AcsXmlNamingExpert {
    private Map<String, String> struct2JavaMap = new HashMap<String, String>();
    public static final String suffix = "J";

    public void setIdlStruct2JavaBindingClassMappings(String string) {
        if (string == null) {
            return;
        }
        for (String string2 : string.split(";")) {
            String string3 = string2.trim();
            int n = string3.indexOf(61);
            if (n <= 0) continue;
            String string4 = string3.substring(0, n).trim();
            String string5 = string3.substring(n + 1).trim();
            this.struct2JavaMap.put(string4, string5);
        }
    }

    public String getBindingClassName(String string) {
        return this.struct2JavaMap.get(string);
    }

    public String getClassNameForStruct(StructType structType) {
        return structType.name() + suffix;
    }

    public String getHolderClassNameForStruct(StructType structType) {
        String string = this.getClassNameForStruct(structType);
        string = string + "Holder";
        return string;
    }

    public String getJavaPackageForStruct(StructType structType) {
        String string = AcsStructPrinter.java_name(structType);
        int n = string.lastIndexOf(46);
        String string2 = null;
        string2 = n > 0 ? string.substring(0, string.lastIndexOf(46)) : string;
        return string2;
    }

    public String getJavaTypeForXmlStruct(StructType structType) {
        String string = this.getJavaPackageForStruct(structType) + '.' + this.getClassNameForStruct(structType);
        return string;
    }

    public String getClassNameForInterface(Interface interface_) {
        return interface_.name();
    }

    public String getJavaPackageForInterface(Interface interface_) {
        String string = AcsInterfacePrinter.java_name(interface_);
        int n = string.lastIndexOf(46);
        String string2 = null;
        string2 = n > 0 ? string.substring(0, string.lastIndexOf(46)) : string;
        return string2;
    }

    public String getJavaTypeForXmlInterface(Interface interface_) {
        String string = this.getJavaPackageForInterface(interface_) + '.' + this.getClassNameForInterface(interface_);
        return string;
    }

    public String getClassNameForXmlTypedef(AliasTypeSpec aliasTypeSpec) {
        String string = aliasTypeSpec.name();
        XmlTypedefInfo xmlTypedefInfo = new XmlTypedefInfo();
        this.checkXmlTypedef(aliasTypeSpec, xmlTypedefInfo);
        if (!xmlTypedefInfo.isXmlEntityStruct || xmlTypedefInfo.isSequence) {
            string = string + suffix;
        }
        return string;
    }

    public String getHolderClassNameForXmlTypedef(AliasTypeSpec aliasTypeSpec) {
        String string = this.getClassNameForXmlTypedef(aliasTypeSpec);
        string = string + "Holder";
        return string;
    }

    public String getJavaTypeForXmlTypedef(AliasTypeSpec aliasTypeSpec) {
        XmlTypedefInfo xmlTypedefInfo = new XmlTypedefInfo();
        this.checkXmlTypedef(aliasTypeSpec, xmlTypedefInfo);
        if (xmlTypedefInfo.isSequence) {
            xmlTypedefInfo.javaType = xmlTypedefInfo.javaType + "[]";
        }
        return xmlTypedefInfo.javaType;
    }

    private void checkXmlTypedef(AliasTypeSpec aliasTypeSpec, XmlTypedefInfo xmlTypedefInfo) {
        VectorType vectorType;
        TypeSpec typeSpec = aliasTypeSpec.originalType();
        if (typeSpec instanceof VectorType) {
            xmlTypedefInfo.isSequence = true;
            vectorType = (VectorType)typeSpec;
            typeSpec = vectorType.elementTypeSpec();
        }
        if (typeSpec instanceof AliasTypeSpec) {
            this.checkXmlTypedef((AliasTypeSpec)typeSpec, xmlTypedefInfo);
        } else if (typeSpec instanceof ConstrTypeSpec) {
            vectorType = ((ConstrTypeSpec)typeSpec.typeSpec()).c_type_spec.declaration();
            if (vectorType instanceof StructType && ((StructType)vectorType).name().equals("XmlEntityStruct")) {
                xmlTypedefInfo.isXmlEntityStruct = true;
                xmlTypedefInfo.javaType = this.getBindingClassName(aliasTypeSpec.name());
            } else {
                TypeDeclaration typeDeclaration = ((ConstrTypeSpec)typeSpec).c_type_spec;
                if (typeDeclaration instanceof StructType) {
                    StructType structType = (StructType)typeDeclaration;
                    xmlTypedefInfo.javaType = this.getJavaTypeForXmlStruct(structType);
                } else if (typeDeclaration instanceof Interface) {
                    Interface interface_ = (Interface)typeDeclaration;
                    xmlTypedefInfo.javaType = typeDeclaration.typeName();
                }
            }
        }
    }

    public String getAcsTypeName(TypeSpec typeSpec, Set<AliasTypeSpec> set, Set<StructType> set2, Set<Interface> set3) {
        String string = null;
        if (typeSpec instanceof AliasTypeSpec) {
            if (set.contains(typeSpec)) {
                string = this.getJavaTypeForXmlTypedef((AliasTypeSpec)typeSpec);
            }
        } else if (typeSpec instanceof ConstrTypeSpec) {
            Interface interface_;
            TypeDeclaration typeDeclaration = ((ConstrTypeSpec)typeSpec).c_type_spec;
            if (typeDeclaration instanceof StructType && set2.contains(typeDeclaration)) {
                string = this.getJavaTypeForXmlStruct((StructType)((ConstrTypeSpec)typeSpec).c_type_spec.declaration());
            } else if (typeDeclaration instanceof Interface && set3.contains(interface_ = JacorbVisitor.resolveForwardDecl((Interface)typeDeclaration))) {
                string = this.getJavaTypeForXmlInterface(interface_);
            }
        }
        if (string == null) {
            string = typeSpec.toString();
        }
        return string;
    }

    private static class XmlTypedefInfo {
        boolean isXmlEntityStruct = false;
        boolean isSequence = false;
        String javaType;

        private XmlTypedefInfo() {
        }
    }
}

