/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.exceptions;

import alma.ACSErr.ErrorTrace;
import alma.ACSErr.NameValue;
import alma.ACSErr.Severity;
import alma.acs.classloading.ContextFinder;
import alma.acs.exceptions.AcsJCompletion;
import alma.acs.exceptions.CorbaExceptionConverter;
import alma.acs.exceptions.ErrorTraceLogLevels;
import alma.acs.exceptions.ErrorTraceManipulator;
import alma.acs.util.UTCUtility;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.omg.CORBA.UserException;

public abstract class AcsJException
extends Exception {
    private static String s_thisHost;
    private static String s_thisProcess;
    protected String m_host;
    protected String m_process;
    protected int m_line;
    protected String m_method;
    protected String m_file;
    protected String m_sourceObject;
    protected String m_threadName;
    protected Severity m_severity;
    protected Properties m_properties;
    protected long m_timeMilli;
    private boolean m_initialized = false;

    public AcsJException() {
        this.init();
    }

    public AcsJException(String message) {
        super(message);
        this.init();
    }

    public AcsJException(String message, Throwable cause) {
        super(message);
        cause = CorbaExceptionConverter.convertHiddenErrorTrace(cause);
        this.init();
        this.initCause(cause);
    }

    public AcsJException(ErrorTrace etCause) {
        this.init();
        Throwable cause = CorbaExceptionConverter.recursiveGetThrowable(etCause);
        this.initCause(cause);
    }

    public AcsJException(String message, ErrorTrace etCause) {
        super(message);
        this.init();
        Throwable cause = CorbaExceptionConverter.recursiveGetThrowable(etCause);
        this.initCause(cause);
    }

    private void init() {
        if (this.m_initialized) {
            return;
        }
        if (s_thisHost == null) {
            try {
                s_thisHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                s_thisHost = "unknown";
            }
        }
        if (s_thisProcess == null) {
            s_thisProcess = ContextFinder.getProcessName();
        }
        this.m_host = s_thisHost;
        this.m_process = s_thisProcess;
        this.m_sourceObject = ContextFinder.getSourceObject();
        this.m_timeMilli = System.currentTimeMillis();
        this.m_threadName = Thread.currentThread().getName();
        this.setSeverity();
        this.m_properties = new Properties();
        StackTraceElement[] stTrElems = this.getStackTrace();
        if (stTrElems != null && stTrElems[0] != null) {
            StackTraceElement stTrEl = stTrElems[0];
            this.m_line = stTrEl.getLineNumber();
            this.m_method = stTrEl.getMethodName();
            this.m_file = stTrEl.getFileName();
        } else {
            this.m_method = "unknown";
            this.m_file = "unknown";
            this.m_line = -1;
        }
        this.m_initialized = true;
    }

    @Override
    public String toString() {
        String strProperties = "";
        for (String string : this.m_properties.keySet()) {
            if (string.equals("javaex.class") || string.equals("javaex.msg")) continue;
            String value = this.m_properties.getProperty(string);
            strProperties = strProperties + string + "='" + value + "' ";
        }
        return super.toString() + (strProperties.length() > 0 ? " [ " + strProperties + "] " : "");
    }

    public static void setProcessName(String name) {
        s_thisProcess = name;
    }

    protected abstract int getErrorType();

    protected abstract int getErrorCode();

    public String getShortDescription() {
        return "";
    }

    public abstract UserException toCorbaException();

    public AcsJCompletion toAcsJCompletion() {
        return new AcsJCompletion(this);
    }

    public void setSeverity() {
        this.m_severity = Severity.Error;
    }

    public Severity getSeverity() {
        return this.m_severity;
    }

    public Object setProperty(String key, String value) {
        return this.m_properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public NameValue[] getNameValueArray() {
        NameValue[] nameValArray = new NameValue[this.m_properties.size()];
        int count = 0;
        for (String string : this.m_properties.keySet()) {
            NameValue nameVal;
            String value = this.m_properties.getProperty(string);
            nameValArray[count] = nameVal = new NameValue(string, value);
            ++count;
        }
        return nameValArray;
    }

    public long getTimestampMillis() {
        return this.m_timeMilli;
    }

    public ErrorTrace getErrorTrace() {
        if (!this.m_initialized) {
            throw new IllegalStateException("This exception has not been initialized. Probably a (generated) exception subclass did not call the superclass constructors!");
        }
        ErrorTrace et = AcsJException.recursiveGetErrorTrace(this, this.m_timeMilli);
        return et;
    }

    private static ErrorTrace recursiveGetErrorTrace(Throwable thr, long defaultTimeMilli) {
        ErrorTrace et = AcsJException.createSingleErrorTrace(thr, defaultTimeMilli);
        Throwable cause = thr.getCause();
        if (cause != null) {
            ErrorTrace causeErrorTrace = AcsJException.recursiveGetErrorTrace(cause, --defaultTimeMilli);
            if (et.previousError == null || et.previousError.length != 1) {
                et.previousError = new ErrorTrace[1];
            }
            et.previousError[0] = causeErrorTrace;
        } else {
            et.previousError = new ErrorTrace[0];
        }
        return et;
    }

    protected ErrorTrace createSingleErrorTrace() {
        ErrorTrace et = new ErrorTrace();
        et.host = this.m_host;
        et.process = this.m_process;
        et.sourceObject = this.m_sourceObject;
        et.lineNum = this.m_line;
        et.routine = this.m_method;
        et.file = this.m_file;
        et.errorType = this.getErrorType();
        et.errorCode = this.getErrorCode();
        et.severity = this.getSeverity();
        et.thread = this.m_threadName;
        et.timeStamp = UTCUtility.utcJavaToOmg((long)this.m_timeMilli);
        et.data = this.getNameValueArray();
        et.shortDescription = this.getShortDescription();
        AcsJException.addExceptionProperties(this, et);
        return et;
    }

    public static ErrorTrace createSingleErrorTrace(Throwable thr, long defaultTimeMilli) {
        ErrorTrace et = null;
        if (thr instanceof AcsJException) {
            et = ((AcsJException)thr).createSingleErrorTrace();
            return et;
        }
        et = new ErrorTrace();
        StackTraceElement[] stTrElems = thr.getStackTrace();
        if (stTrElems != null && stTrElems[0] != null) {
            StackTraceElement stTrEl = stTrElems[0];
            et.file = stTrEl.getFileName();
            et.routine = stTrEl.getMethodName();
            et.lineNum = stTrEl.getLineNumber();
        } else {
            et.routine = "unknown";
            et.file = "unknown";
            et.lineNum = -1;
        }
        et.host = s_thisHost;
        et.process = s_thisProcess;
        et.sourceObject = ContextFinder.getSourceObject();
        et.thread = "NA";
        et.timeStamp = UTCUtility.utcJavaToOmg((long)defaultTimeMilli);
        et.errorType = 9;
        et.errorCode = -1;
        et.shortDescription = thr.getClass().getName();
        et.severity = Severity.Error;
        et.data = new NameValue[0];
        AcsJException.addExceptionProperties(thr, et);
        return et;
    }

    private static void addExceptionProperties(Throwable thr, ErrorTrace et) {
        String classname = thr.getClass().getName();
        ErrorTraceManipulator.setProperty(et, "javaex.class", classname);
        if (thr.getMessage() != null) {
            ErrorTraceManipulator.setProperty(et, "javaex.msg", thr.getMessage());
        }
    }

    public void log(Logger logger) {
        Throwable thr = this;
        String stackID = logger.getName() + System.currentTimeMillis();
        for (int stackLevel = this.getTraceDepth() - 1; stackLevel >= 0; --stackLevel) {
            ErrorTrace et = AcsJException.createSingleErrorTrace(thr, this.m_timeMilli - 1L);
            LogRecord logRec = this.createSingleErrorTraceLogRecord(et, stackID, stackLevel);
            logger.log(logRec);
            if (stackLevel <= 0) continue;
            thr = thr.getCause();
        }
    }

    LogRecord createSingleErrorTraceLogRecord(ErrorTrace et, String stackID, int stackLevel) {
        Level logLevel = ErrorTraceLogLevels.mapErrorLevelToLogLevel(et.severity);
        String message = et.shortDescription.trim();
        message = message + " (type=" + et.errorType + ", code=" + et.errorCode + ")";
        String usermessage = ErrorTraceManipulator.getProperty(et, "javaex.msg");
        if (usermessage != null && usermessage.trim().length() > 0) {
            message = message + " :: " + usermessage.trim();
        }
        LogRecord logRec = new LogRecord(logLevel, message);
        logRec.setMillis(UTCUtility.utcOmgToJava((long)et.timeStamp));
        logRec.setSourceClassName(et.file);
        logRec.setSourceMethodName(et.routine);
        logRec.setLoggerName(et.sourceObject);
        HashMap<String, Object> specialLogProperties = new HashMap<String, Object>();
        specialLogProperties.put("isAcsPropertiesMap", Boolean.TRUE);
        specialLogProperties.put("Line", new Long(et.lineNum));
        specialLogProperties.put("ThreadName", et.thread);
        specialLogProperties.put("HostName", et.host);
        specialLogProperties.put("StackId", stackID);
        specialLogProperties.put("StackLevel", new Long(stackLevel));
        specialLogProperties.put("ProcessName", et.process);
        specialLogProperties.put("SourceObject", et.sourceObject);
        Properties etProperties = ErrorTraceManipulator.getProperties(et);
        etProperties.remove("javaex.class");
        etProperties.remove("javaex.msg");
        logRec.setParameters(new Object[]{specialLogProperties, etProperties});
        return logRec;
    }

    public int getTraceDepth() {
        int depth = 1;
        for (Throwable cause = this.getCause(); cause != null; cause = cause.getCause()) {
            ++depth;
        }
        return depth;
    }

    public String getFile() {
        return this.m_file;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getLine() {
        return this.m_line;
    }

    public String getMethod() {
        return this.m_method;
    }

    public String getProcess() {
        return this.m_process;
    }

    public String getThreadName() {
        return this.m_threadName;
    }

    public String getSourceObject() {
        return this.m_sourceObject;
    }
}

