/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.classloading;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class JarOrderOptimizer
implements Comparator<File> {
    private boolean verbose = false;
    public static final String PROPERTY_APPLICATION_TOPJARS = "acs.system.classpath.appltopjars";
    public static final String ACS_TOP_JARS_FILENAME = "AcsTopJars.txt";
    private final Map<String, Integer> topJarMap;

    JarOrderOptimizer(boolean verbose) {
        this.verbose = verbose;
        this.topJarMap = this.readJarsFromFile();
        int i = this.topJarMap.size();
        String applJarPath = System.getProperty(PROPERTY_APPLICATION_TOPJARS);
        if (applJarPath != null) {
            String[] applJarNames = this.parseJarNames(applJarPath);
            for (int j = 0; j < applJarNames.length; ++j) {
                if (this.topJarMap.containsKey(applJarNames[j])) continue;
                this.topJarMap.put(applJarNames[j], i + j);
            }
        }
    }

    private HashMap<String, Integer> readJarsFromFile() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        InputStream stream = this.getClass().getResourceAsStream(ACS_TOP_JARS_FILENAME);
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            String line;
            BufferedReader br = new BufferedReader(reader);
            int key = 0;
            while ((line = br.readLine()) != null) {
                int pos = line.indexOf(35);
                if (pos >= 0) {
                    line = line.substring(0, pos).trim();
                }
                if (line.endsWith(".jar")) {
                    ret.put(line, key++);
                    continue;
                }
                if (line.isEmpty()) continue;
                System.err.println("\nWrong format of ACS top jar [" + line + "]: jar discarded!\nCheck content of " + ACS_TOP_JARS_FILENAME + "\n");
            }
            br.close();
            ((Reader)reader).close();
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return ret;
    }

    @Override
    public int compare(File f1, File f2) {
        int ret = 0;
        if (f1 == null || f2 == null) {
            throw new NullPointerException("bad null arg");
        }
        String n1 = f1.getName();
        String n2 = f2.getName();
        Integer i1 = this.topJarMap.get(n1);
        Integer i2 = this.topJarMap.get(n2);
        if (i1 != null) {
            ret = i2 != null ? i1.compareTo(i2) : -1;
        } else if (i2 != null) {
            ret = 1;
        } else {
            return n1.compareTo(n2);
        }
        return ret;
    }

    void sortJars(List<File> jarlist) {
        Collections.sort(jarlist, this);
    }

    List<File> getTopJarsOnly(List<File> allJars) {
        ArrayList<File> topJars = new ArrayList<File>();
        for (File jarfile : allJars) {
            if (!this.topJarMap.containsKey(jarfile.getName())) continue;
            topJars.add(jarfile);
        }
        return topJars;
    }

    private String[] parseJarNames(String jarNamePath) {
        StringTokenizer tok = new StringTokenizer(jarNamePath, ":" + File.pathSeparatorChar);
        ArrayList<String> jarNameList = new ArrayList<String>();
        int i = 0;
        while (tok.hasMoreTokens()) {
            String jarName = tok.nextToken();
            if (jarName != null && jarName.trim().length() > 0) {
                if (!(jarName = jarName.trim()).toLowerCase().endsWith(".jar")) {
                    jarName = jarName + ".jar";
                }
                jarNameList.add(jarName);
            }
            ++i;
        }
        return jarNameList.toArray(new String[jarNameList.size()]);
    }

    boolean isClassKnownToBeUnavailable(String name) {
        return name.startsWith("sun.util.logging.") || name.startsWith("sun.text.resources.") || name.startsWith("sun.awt.resources.") || name.startsWith("com.sun.swing.internal.plaf.");
    }
}

