/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.concurrent;

import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    private String threadNamePrefix;

    public DaemonThreadFactory() {
    }

    public DaemonThreadFactory(String threadNamePrefix) {
        this.setThreadNamePrefix(threadNamePrefix);
    }

    @Override
    public Thread newThread(Runnable command) {
        String threadName;
        Thread t = new Thread(command);
        t.setDaemon(true);
        String assignedName = t.getName();
        if (this.threadNamePrefix != null) {
            assignedName = this.threadNamePrefix + assignedName;
        }
        if ((threadName = this.getThreadName(assignedName)) == null) {
            threadName = assignedName;
        }
        t.setName(threadName);
        return t;
    }

    protected String getThreadName(String assignedName) {
        return assignedName;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }
}

