/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.monitoring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Logger;

public class DynamicInterceptor
implements InvocationHandler {
    private final Object delegate;
    private final Logger logger;
    private final ClassLoader contextCL;
    private final InterceptionHandlerFactory interceptionHandlerFactory;

    protected DynamicInterceptor(Object delegate, Logger logger, ClassLoader contextCL, InterceptionHandlerFactory interceptionHandlerFactory) {
        this.delegate = delegate;
        this.logger = logger;
        this.contextCL = contextCL;
        this.interceptionHandlerFactory = interceptionHandlerFactory;
    }

    public static <T> T createDynamicInterceptor(Class<T> dynInterface, Object delegate, Logger logger, ClassLoader contextCL, InterceptionHandlerFactory interceptionHandlerFactory) {
        DynamicInterceptor invHandler = new DynamicInterceptor(delegate, logger, contextCL, interceptionHandlerFactory);
        Object proxy = Proxy.newProxyInstance(dynInterface.getClassLoader(), new Class[]{dynInterface}, (InvocationHandler)invHandler);
        return (T)proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InterceptionHandler handler = this.interceptionHandlerFactory.createInterceptionHandler();
        boolean allowCall = handler.callReceived(method, args);
        Object retObj = null;
        Throwable realThr = null;
        if (allowCall) {
            try {
                ClassLoader oldContCL = Thread.currentThread().getContextClassLoader();
                if (this.contextCL != null) {
                    Thread.currentThread().setContextClassLoader(this.contextCL);
                }
                try {
                    retObj = method.invoke(this.delegate, args);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldContCL);
                }
            }
            catch (Throwable thr) {
                realThr = this.unwindThrowableHierarchy(thr);
            }
        } else {
            this.logger.fine("Rejected call to method '" + method.getName() + "' as advised by handler " + handler.getClass().getName());
        }
        Object retObj2 = handler.callFinished(retObj, args, realThr);
        return retObj2;
    }

    private Throwable unwindThrowableHierarchy(Throwable thr) {
        Throwable realThr = thr;
        if ((thr instanceof InvocationTargetException || thr instanceof UndeclaredThrowableException) && thr.getCause() != null) {
            realThr = thr.getCause();
            return this.unwindThrowableHierarchy(realThr);
        }
        return realThr;
    }

    public static interface InterceptionHandlerFactory {
        public InterceptionHandler createInterceptionHandler();
    }

    public static interface InterceptionHandler {
        public boolean callReceived(Method var1, Object[] var2);

        public Object callFinished(Object var1, Object[] var2, Throwable var3) throws Throwable;
    }
}

