/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.testsupport.tat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import junit.runner.Version;
import org.junit.internal.JUnitSystem;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class TATJUnitRunner {
    private PrintStream oldSysOut;
    private PrintStream oldSysErr;
    private File sysOutFile;
    private PrintStream newSysOut;
    private File sysErrFile;
    private PrintStream newSysErr;
    private File resultFile;
    private PrintStream resultOut;
    private JUnitCore delegate = new JUnitCore();
    private boolean keepTestOutput = false;

    private void createStreams(Class<?> testClass) throws IOException {
        this.sysOutFile = this.createTmpFile("sysout", testClass);
        this.newSysOut = new PrintStream(new FileOutputStream(this.sysOutFile, true));
        this.sysErrFile = this.createTmpFile("syserr", testClass);
        this.newSysErr = new PrintStream(new FileOutputStream(this.sysErrFile, true));
        this.resultFile = this.createTmpFile("result", testClass);
        this.resultOut = new PrintStream(new FileOutputStream(this.resultFile, true));
    }

    private void redirectSysStreams() throws IOException {
        this.oldSysOut = System.out;
        System.setOut(this.newSysOut);
        this.oldSysErr = System.err;
        System.setErr(this.newSysErr);
    }

    private void restoreSysStreams() {
        System.setOut(this.oldSysOut);
        System.setErr(this.oldSysErr);
    }

    private void closeStreams() {
        this.newSysOut.close();
        this.newSysErr.close();
        this.resultOut.close();
    }

    private void dumpAndDeleteCapturedFile(File source, String sectionHeader) {
        byte[] buffer = new byte[2048];
        int status = -1;
        boolean error = false;
        try {
            FileInputStream sourceStream = new FileInputStream(source);
            System.err.println(sectionHeader);
            System.err.println("<<<<<<<<<<<<<<<<<<<");
            do {
                try {
                    status = sourceStream.read(buffer);
                }
                catch (IOException ex) {
                    error = true;
                    System.err.print("Error reading file: " + ex.getMessage());
                }
                if (status <= 0) continue;
                System.err.write(buffer, 0, status);
            } while (status > 0);
            System.err.println(">>>>>>>>>>>>>>>>>>>");
            System.err.println();
            try {
                sourceStream.close();
            }
            catch (IOException ex) {
                error = true;
                System.err.print("Couldn't close file: " + ex.getMessage());
            }
        }
        catch (FileNotFoundException ex) {
            error = true;
            System.err.print("Error opening file: " + ex.getMessage());
        }
        if (!error && !this.keepTestOutput) {
            source.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runMain(Class<?> testClass) throws IOException {
        Result result = null;
        try {
            this.keepTestOutput = testClass.isAnnotationPresent(KeepTestOutput.class);
            this.createStreams(testClass);
            this.redirectSysStreams();
            JUnitSystem system = new JUnitSystem(){

                public void exit(int code) {
                    System.exit(code);
                }

                public PrintStream out() {
                    return TATJUnitRunner.this.resultOut;
                }
            };
            system.out().println("JUnit version " + Version.id());
            TextListener listener = new TextListener(system);
            this.delegate.addListener((RunListener)listener);
            result = this.delegate.run(new Class[]{testClass});
        }
        finally {
            this.restoreSysStreams();
            this.closeStreams();
        }
        int total = result.getRunCount();
        int success = total - result.getFailureCount();
        String runnerReport = "TEST_RUNNER_REPORT success/total: " + success + "/" + total;
        System.out.println(runnerReport);
        if (result.wasSuccessful()) {
            System.out.println("JUnit test run succeeded");
            if (!this.keepTestOutput) {
                this.sysOutFile.delete();
                this.sysErrFile.delete();
                this.resultFile.delete();
            }
        } else {
            System.err.println("JUnitRunner: Errors and/or failures during test execution!\n");
            this.dumpAndDeleteCapturedFile(this.resultFile, "Test execution trace:");
            this.dumpAndDeleteCapturedFile(this.sysOutFile, "System.out during test execution:");
            this.dumpAndDeleteCapturedFile(this.sysErrFile, "System.err during test execution:");
        }
        return result;
    }

    private File createTmpFile(String prefix, Class<?> testClass) throws IOException {
        File tmpFile = File.createTempFile(prefix + "-" + testClass.getSimpleName() + "-", ".log", new File(System.getProperty("user.dir")));
        return tmpFile;
    }

    public static void run(Class testClass) throws FileNotFoundException {
        TATJUnitRunner inst = new TATJUnitRunner();
        try {
            inst.runMain(testClass);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new FileNotFoundException(ex.toString());
        }
    }

    public static void main(String[] args) {
        Result result = null;
        try {
            if (args.length < 1 || args[0] == null || args[0].length() == 0) {
                System.err.println("usage: JUnit4Runner testclassname");
            } else {
                TATJUnitRunner inst = new TATJUnitRunner();
                String testClassName = args[0];
                Class<?> testClass = Class.forName(testClassName);
                result = inst.runMain(testClass);
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            System.exit(1);
        }
        if (result.wasSuccessful()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface KeepTestOutput {
    }
}

