/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.util;

import alma.acs.util.ACSPorts;
import alma.acs.util.IorParser;

public class AcsLocations {
    public static String MANAGER_SYMBOL = "Manager";
    public static String NAMESERVICE_SYMBOL = "NameService";
    public static String INTERFACEREPOSITORY_SYMBOL = "InterfaceRepository";
    public static String CDB_SYMBOL = "CDB";
    public static final String SERVICESDAEMON_SYMBOL = "ACSServicesDaemon";
    public static final String CONTAINERDAEMON_SYMBOL = "ACSContainerDaemon";

    public static String getLocalIP() {
        return ACSPorts.getIP();
    }

    public static String figureOutManagerLocation() {
        String managerLoc;
        String baseport = System.getProperty("ACS.baseport", "").trim();
        String managerPort = "";
        if (!baseport.equals("")) {
            try {
                int acsInstance = -1;
                acsInstance = Integer.parseInt(baseport);
                if (acsInstance > -1) {
                    managerPort = ACSPorts.globalInstance(acsInstance).giveManagerPort();
                }
            }
            catch (NumberFormatException acsInstance) {
                // empty catch block
            }
        }
        if (!(managerLoc = System.getProperty("ACS.manager", "").trim()).equals("")) {
            return managerLoc;
        }
        if (!managerPort.equals("")) {
            return AcsLocations.convertToManagerLocation(ACSPorts.getIP(), managerPort);
        }
        return AcsLocations.convertToManagerLocation(ACSPorts.getIP(), "3000");
    }

    public static String[] convert(String loc) throws IllegalArgumentException {
        String host = null;
        String port = null;
        if (loc.regionMatches(true, 0, "ior", 0, "ior".length())) {
            String[] parseResult = IorParser.parse(loc);
            host = parseResult[0];
            port = parseResult[1];
        } else if (loc.regionMatches(true, 0, "corbaloc", 0, "corbaloc".length())) {
            int a = loc.indexOf(":", 0) + 1;
            int b = loc.indexOf(":", a) + 1;
            int c = loc.indexOf(":", b);
            int d = c + 1;
            int e = loc.indexOf("/", d);
            if (b == -1 || c == -1 || d == -1 || e == -1) {
                throw new IllegalArgumentException("not a valid location: \"" + loc + "\"");
            }
            host = loc.substring(b, c);
            port = loc.substring(d, e);
        } else {
            throw new IllegalArgumentException("not a valid location: \"" + loc + "\"");
        }
        return new String[]{host, port};
    }

    public static String convertToManagerLocation(String host, String port) {
        return AcsLocations.convertToManagerLocation(host, port, "");
    }

    public static String convertToManagerLocation(String host, String port, String protocol) {
        return "corbaloc:" + protocol + ":" + host.trim() + ":" + port.trim() + "/" + MANAGER_SYMBOL;
    }

    public static String convertToNameServiceLocation(String host, String port) {
        return AcsLocations.convertToNameServiceLocation(host, port, "");
    }

    public static String convertToNameServiceLocation(String host, String port, String protocol) {
        return "corbaloc:" + protocol + ":" + host.trim() + ":" + port.trim() + "/" + NAMESERVICE_SYMBOL;
    }

    public static String convertToInterfaceRepositoryLocation(String host, String port) {
        return AcsLocations.convertToInterfaceRepositoryLocation(host, port, "");
    }

    public static String convertToInterfaceRepositoryLocation(String host, String port, String protocol) {
        return "corbaloc:" + protocol + ":" + host.trim() + ":" + port.trim() + "/" + INTERFACEREPOSITORY_SYMBOL;
    }

    public static String convertToCdbLocation(String host, String port) {
        return AcsLocations.convertToCdbLocation(host, port, "");
    }

    public static String convertToCdbLocation(String host, String port, String protocol) {
        return "corbaloc:" + protocol + ":" + host.trim() + ":" + port.trim() + "/" + CDB_SYMBOL;
    }

    public static String convertToServicesDaemonLocation(String host) {
        return "corbaloc::" + host.trim() + ":" + ACSPorts.getServicesDaemonPort() + "/" + SERVICESDAEMON_SYMBOL;
    }

    public static String convertToContainerDaemonLocation(String host) {
        return "corbaloc::" + host.trim() + ":" + ACSPorts.getContainerDaemonPort() + "/" + CONTAINERDAEMON_SYMBOL;
    }
}

