/*
 * Decompiled with CFR 0.152.
 */
package alma.hibernate.util;

import alma.hibernate.util.JdbcNativeExtractor;
import com.mchange.v2.c3p0.impl.C3P0ResultSetPeeker;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StringClobType;
import org.hibernate.usertype.UserType;

public class HibernateXmlType
extends StringClobType
implements UserType,
Serializable {
    private static final String COM_MCHANGE_V2_C3P0 = "com.mchange.v2.c3p0";
    private static final String ORACLE_JDBC = "oracle.jdbc";
    private static final String GET_STRING_VAL = "getStringVal";
    private static final String XML_TYPE = "oracle.xdb.XMLType";
    private static final long serialVersionUID = 2838406736360323902L;

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor si, Object owner) throws HibernateException, SQLException {
        if (rs.getClass().getName().startsWith(COM_MCHANGE_V2_C3P0)) {
            rs = C3P0ResultSetPeeker.getInnerFrom(rs);
        }
        if (rs.getClass().getName().startsWith(ORACLE_JDBC)) {
            try {
                Class<?> clazz = Class.forName(XML_TYPE);
                Method m = clazz.getMethod(GET_STRING_VAL, new Class[0]);
                Object xmlType = rs.getObject(names[0]);
                return xmlType != null ? m.invoke(xmlType, new Object[0]) : null;
            }
            catch (Exception e) {
                throw new SQLException("Failed to convert XMLTYPE String to Document for retrieval", e);
            }
        }
        return super.nullSafeGet(rs, names, si, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor si) throws HibernateException, SQLException {
        JdbcNativeExtractor extractor = new JdbcNativeExtractor();
        Connection connection = extractor.getNativeConnection(st.getConnection());
        if (connection.getClass().getName().startsWith(ORACLE_JDBC)) {
            try {
                Object xmlType = null;
                if (value != null) {
                    Class<?> clazz = Class.forName(XML_TYPE);
                    Constructor<?> con = clazz.getConstructor(Connection.class, String.class);
                    xmlType = con.newInstance(connection, (String)value);
                    st.setObject(index, xmlType);
                }
                st.setNull(index, 2007, "SYS.XMLTYPE");
            }
            catch (Exception e) {
                throw new SQLException("Failed to convert Document to XMLTYPE String for storage", e);
            }
        } else {
            super.nullSafeSet(st, value, index, si);
        }
    }
}

