/*
 * Decompiled with CFR 0.152.
 */
package alma.correlatorSrc.CorrConfigValidator;

import alma.BasebandNameMod.BasebandName;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidKeyEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidModeEx;
import alma.CorrelationModeMod.CorrelationMode;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.CorrConfigModeClass.CorrConfigModeClass;
import alma.Correlator.CorrelatorConfiguration;
import alma.Correlator.DataRatesBL;
import alma.Correlator.DataRatesPerBasebandBL;
import alma.Correlator.SpectralWindow;
import alma.Correlator.eFilterMode;
import alma.Correlator.eFraction;
import alma.SidebandProcessingModeMod.SidebandProcessingMode;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidatorBase;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public abstract class CorrConfigValidatorBLDataRateCalcImpl
extends CorrConfigValidatorBase {
    private static Logger m_logger = Logger.getLogger(CorrConfigValidatorBLDataRateCalcImpl.class.getName());

    protected CorrConfigValidatorBLDataRateCalcImpl() {
    }

    public void calculateDetailedDataRate(CorrConfigModeClass modesTable, CorrelatorConfiguration config, int[] cais, int[] intersections, DataRatesBL dataRates) throws AcsJInvalidModeEx, AcsJInvalidKeyEx {
        long partialDumps = config.dumpDuration / 160000L;
        dataRates.master = 0.0f;
        dataRates.basebands = new DataRatesPerBasebandBL[4];
        for (int i = 0; i < 4; ++i) {
            dataRates.basebands[i] = new DataRatesPerBasebandBL();
            dataRates.basebands[i].dpi = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            dataRates.basebands[i].cluster = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        }
        int tintersections = 0;
        for (int cai : cais) {
            if (cai < 32) {
                intersections[0] = intersections[0] + 1;
                continue;
            }
            if (cai < 48) {
                intersections[1] = intersections[1] + 1;
            } else {
                intersections[2] = intersections[2] + 1;
            }
            intersections[3] = intersections[3] + 1;
        }
        if (config.baseBands[0].dataProducts == CorrelationMode.AUTO_ONLY) {
            intersections[1] = 0;
            intersections[2] = 0;
        } else {
            intersections[1] = 2 * intersections[0] * intersections[1];
            intersections[2] = 2 * intersections[0] * intersections[2];
            intersections[0] = intersections[0] * intersections[0];
            intersections[3] = intersections[3] * intersections[3];
        }
        for (int i : intersections) {
            tintersections += i;
        }
        HashMap<BasebandName, Integer> bbn2idx = new HashMap<BasebandName, Integer>();
        bbn2idx.put(BasebandName.BB_1, 0);
        bbn2idx.put(BasebandName.BB_2, 1);
        bbn2idx.put(BasebandName.BB_3, 2);
        bbn2idx.put(BasebandName.BB_4, 3);
        for (BaseBandConfig bb : config.baseBands) {
            int modeNumber = modesTable.findModeFromResolution((float)bb.spectralWindows[0].effectiveBandwidthMHz, (long)bb.spectralWindows[0].effectiveNumberOfChannels, bb.spectralWindows[0].correlationBits, bb.spectralWindows[0].correlationNyquistOversampling, bb.spectralWindows[0].polnProductsSeq, eFraction.FRACTION_FULL);
            int antennaIntersectionSize = modesTable.getMode((int)modeNumber).filterMode == eFilterMode.FILTER_TDM ? 256 : 8192;
            if (bb.sideBandSeparationMode == SidebandProcessingMode.PHASE_SWITCH_SEPARATION) {
                antennaIntersectionSize *= 3;
            }
            for (int i = 0; i < 4; ++i) {
                dataRates.basebands[((Integer)bbn2idx.get((Object)bb.basebandName)).intValue()].dpi[i] = (float)(Math.ceil((float)intersections[i] / (float)partialDumps) * (double)antennaIntersectionSize * 4.0) / 0.016f / 1024.0f / 1024.0f;
            }
        }
        Map<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> basebandDataRates = this.calculateTotalDataRateForConfig(config, cais.length);
        for (Map.Entry<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> bbdr : basebandDataRates.entrySet()) {
            float tbbdr = 0.0f;
            dataRates.master = (float)((double)dataRates.master + bbdr.getValue().ancillary);
            tbbdr = (float)((double)tbbdr + bbdr.getValue().ancillary);
            for (double spwdr : bbdr.getValue().spectralWindow) {
                dataRates.master = (float)((double)dataRates.master + spwdr);
                tbbdr = (float)((double)tbbdr + spwdr);
            }
            for (int i = 0; i < 4; ++i) {
                dataRates.basebands[((Integer)bbn2idx.get((Object)bbdr.getKey())).intValue()].cluster[i] = tbbdr * (float)intersections[i] / (float)tintersections;
            }
        }
    }

    @Override
    public Map<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> calculateTotalDataRateForConfig(CorrelatorConfiguration config, int numberOfAntennas) {
        HashMap<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> result = new HashMap<BasebandName, CorrConfigValidatorBase.BaseBandDataRate>();
        for (BaseBandConfig bb : config.baseBands) {
            CorrConfigValidatorBase.BaseBandDataRate bbDataRates = this.calcDataRateForBaseBand(config.APCDataSets.length, config.integrationDuration, config.channelAverageDuration, bb, numberOfAntennas);
            result.put(bb.basebandName, bbDataRates);
        }
        return result;
    }

    public CorrConfigValidatorBase.BaseBandDataRate calcDataRateForBaseBand(int apcLength, long integrationDuration, long channelAverageDuration, BaseBandConfig bb, int numberOfAntennas) {
        long autoDataBytes = 4L;
        long crossDataBytes = 4L;
        long HeaderSize = 1300L;
        long Nantenna = numberOfAntennas;
        long cross = bb.dataProducts.value() == CorrelationMode.CROSS_AND_AUTO.value() ? 1L : 0L;
        long NpolBBMax = 0L;
        for (SpectralWindow sw : bb.spectralWindows) {
            if (!sw.useThisSpectralWindow) continue;
            NpolBBMax = Math.max(NpolBBMax, (long)sw.polnProductsSeq.length);
        }
        if (bb.spectralWindows[0].effectiveBandwidthMHz != 2000.0) {
            crossDataBytes = 2L;
        }
        CorrConfigValidatorBase.BaseBandDataRate result = new CorrConfigValidatorBase.BaseBandDataRate();
        result.spectralWindow = new double[bb.spectralWindows.length];
        double timeInterval2sec = 1.0E-7;
        double bbSizeFull = 1300.0;
        double bbSizeChannel = 1300.0;
        long Mi = 0x100000L;
        result.ancillary = (1300.0 / ((double)integrationDuration * 1.0E-7) + 1300.0 / ((double)channelAverageDuration * 1.0E-7)) / 1048576.0;
        for (int i = 0; i < result.spectralWindow.length; ++i) {
            SpectralWindow sw = bb.spectralWindows[i];
            long useThisSpectralWindow = sw.useThisSpectralWindow ? 1L : 0L;
            long NchannelAverageRegions = sw.channelAverageRegions.length;
            long Npol = sw.polnProductsSeq.length;
            assert (sw.spectralAveragingFactor != 0);
            long Nch = sw.effectiveNumberOfChannels / sw.spectralAveragingFactor;
            double SizeFull = (double)(useThisSpectralWindow * Nch * Nantenna) * (4.0 + (double)(crossDataBytes * cross * 2L * (long)apcLength * (Nantenna - 1L)) / 2.0) * (double)Npol;
            double SizeChannel = (double)(useThisSpectralWindow * NchannelAverageRegions * Nantenna) * (4.0 + (double)(crossDataBytes * cross * 2L * (Nantenna - 1L)) / 2.0) * (double)Npol;
            result.spectralWindow[i] = (SizeFull / ((double)integrationDuration * 1.0E-7) + SizeChannel / ((double)channelAverageDuration * 1.0E-7)) / 1048576.0;
        }
        return result;
    }
}

