/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.AcsLogRecord;
import alma.acs.logging.LogParameterUtil;
import alma.acs.logging.adapters.JacORBFilter;
import alma.acs.logging.config.LogConfig;
import alma.acs.logging.config.LogConfigSubscriber;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.logging.statistics.AcsLoggerStatistics;
import alma.acs.util.IsoDateFormat;
import alma.acs.util.StopWatch;
import alma.maci.loggingconfig.UnnamedLogger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class AcsLogger
extends Logger
implements LogConfigSubscriber {
    protected static final int offValue = Level.OFF.intValue();
    public AcsLoggerStatistics stats;
    protected final Logger delegate;
    private final Set<String> loggerClassNames = new HashSet<String>();
    private final Set<String> callStacksToBeIgnored = new HashSet<String>();
    private LogConfig logConfig;
    private String loggerName;
    private String processName;
    private String sourceObject;
    private boolean noLevelWarningPrinted = false;
    private final boolean DEBUG = Boolean.getBoolean("alma.acs.logging.verbose");
    private final boolean PROFILE = Boolean.getBoolean("alma.acs.logging.profile.local");
    private final int profileStatSize = 100;
    private DescriptiveStatistics profileLogTimeStats;
    private NumberFormat profileMillisecFormatter;
    private StopWatch profileSlowestCallStopWatch;

    public AcsLogger(String name, String resourceBundleName, LogConfig logConfig) {
        this(name, resourceBundleName, logConfig, false, null);
    }

    protected AcsLogger(String name, String resourceBundleName, LogConfig logConfig, boolean allowNullLogConfig, Logger delegate) {
        super(name, resourceBundleName);
        this.delegate = delegate;
        this.logConfig = logConfig;
        if (this.DEBUG) {
            System.out.println("*** AcsLogger running in DEBUG mode!");
        }
        if (this.PROFILE) {
            this.profileLogTimeStats = new DescriptiveStatistics();
            this.profileMillisecFormatter = new DecimalFormat("#.#");
        }
        this.addLoggerClass(AcsLogger.class);
        this.addLoggerClass(Logger.class);
        if (logConfig != null) {
            this.configureLogging(logConfig);
            logConfig.addSubscriber(this);
        } else if (!allowNullLogConfig) {
            throw new NullPointerException("LogConfig must not be null");
        }
        this.stats = new AcsLoggerStatistics();
    }

    public static AcsLogger createUnconfiguredLogger(String name, String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger jdkLogger = manager.getLogger(name);
        if (jdkLogger != null && !(jdkLogger instanceof AcsLogger)) {
            throw new IllegalArgumentException("Logger " + name + " already exists but is not of subtype AcsLogger.");
        }
        AcsLogger result = (AcsLogger)jdkLogger;
        if (result == null) {
            result = new AcsLogger(name, resourceBundleName, null, true, null);
            manager.addLogger(result);
            result = (AcsLogger)manager.getLogger(name);
        }
        if (result.getResourceBundleName() != null && !result.getResourceBundleName().equals(resourceBundleName)) {
            throw new IllegalArgumentException(result.getResourceBundleName() + " != " + resourceBundleName);
        }
        return result;
    }

    public static AcsLogger fromJdkLogger(Logger logger, String wrapLoggerName) {
        if (logger instanceof AcsLogger) {
            return (AcsLogger)logger;
        }
        String acsLoggerName = wrapLoggerName != null ? wrapLoggerName.trim() : logger.getName() + "wrapper";
        AcsLogger ret = new AcsLogger(acsLoggerName, logger.getResourceBundleName(), null, true, logger);
        ret.setLevel(logger.getLevel());
        ret.setParent(logger.getParent());
        return ret;
    }

    void setLoggerName(String newLoggerName) {
        if (!this.getLoggerName().equals(newLoggerName)) {
            String oldLoggerName = this.getLoggerName();
            if (this.DEBUG) {
                System.out.println("Renaming logger '" + oldLoggerName + "' to '" + newLoggerName + "'.");
            }
            this.loggerName = newLoggerName;
            if (this.logConfig != null) {
                this.logConfig.renameNamedLoggerConfig(oldLoggerName, newLoggerName);
                this.configureLogging(this.logConfig);
            }
        }
    }

    String getLoggerName() {
        return this.loggerName != null ? this.loggerName : this.getName();
    }

    void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessName() {
        return this.processName;
    }

    void setSourceObject(String sourceObject) {
        this.sourceObject = sourceObject;
    }

    public String getSourceObject() {
        return this.sourceObject;
    }

    public void logToAudience(Level level, String msg, String audience) {
        AcsLogRecord lr = this.createAcsLogRecord(level, msg);
        lr.setAudience(audience);
        this.log(lr);
    }

    public void logToAudience(Level level, String msg, Throwable thr, String audience) {
        AcsLogRecord lr = this.createAcsLogRecord(level, msg);
        lr.setAudience(audience);
        lr.setThrown(thr);
        this.log(lr);
    }

    public AcsLogRecord createAcsLogRecord(Level level, String msg) {
        AcsLogRecord lr = new AcsLogRecord(level, msg, this.getName());
        return lr;
    }

    @Override
    public void log(LogRecord record) {
        LogParameterUtil paramUtil;
        Map<String, Object> specialProperties;
        Logger loggerWithLevel;
        if (record.getLevel().intValue() == Level.OFF.intValue() || record.getLevel().intValue() == AcsLogLevel.OFF.intValue()) {
            throw new IllegalArgumentException("Level OFF must not be used for actual logging, but only for level filtering.");
        }
        StopWatch sw_all = null;
        if (this.PROFILE) {
            sw_all = new StopWatch(null);
        }
        for (loggerWithLevel = this; loggerWithLevel != null && loggerWithLevel.getLevel() == null && loggerWithLevel.getParent() != null; loggerWithLevel = loggerWithLevel.getParent()) {
        }
        int levelValue = -1;
        if (loggerWithLevel.getLevel() == null) {
            if (!this.noLevelWarningPrinted) {
                System.out.println("Logger configuration error: no log level found for logger " + this.getLoggerName() + " or its ancestors. Will use Level.ALL instead.");
                this.noLevelWarningPrinted = true;
            }
            levelValue = Level.ALL.intValue();
        } else {
            this.noLevelWarningPrinted = false;
            levelValue = loggerWithLevel.getLevel().intValue();
        }
        if (record.getLevel().intValue() < levelValue || levelValue == offValue) {
            return;
        }
        if (this.loggerName != null) {
            record.setLoggerName(this.loggerName);
        }
        if ((specialProperties = (paramUtil = new LogParameterUtil(record)).extractSpecialPropertiesMap()) == null) {
            specialProperties = LogParameterUtil.createPropertiesMap();
            List<Object> paramList = paramUtil.getNonSpecialPropertiesMapParameters();
            paramList.add(0, specialProperties);
            record.setParameters(paramList.toArray());
            String threadName = Thread.currentThread().getName();
            specialProperties.put("ThreadName", threadName);
            specialProperties.put("ProcessName", this.processName);
            specialProperties.put("SourceObject", this.sourceObject);
            StackTraceElement[] stack = new Throwable().getStackTrace();
            boolean foundNonLogFrame = false;
            for (int ix = 0; ix < stack.length; ++ix) {
                StackTraceElement frame = stack[ix];
                String cname = frame.getClassName();
                if (!foundNonLogFrame && !this.loggerClassNames.contains(cname)) {
                    record.setSourceClassName(frame.getFileName());
                    record.setSourceMethodName(frame.getMethodName());
                    int lineNumber = frame.getLineNumber();
                    specialProperties.put("Line", lineNumber);
                    foundNonLogFrame = true;
                    if (this.callStacksToBeIgnored.isEmpty()) break;
                }
                if (!foundNonLogFrame || !this.callStacksToBeIgnored.contains(this.concatenateIgnoreLogData(cname, frame.getMethodName()))) continue;
                return;
            }
        }
        StopWatch sw_afterAcsLogger = null;
        if (this.PROFILE) {
            sw_afterAcsLogger = sw_all.createStopWatchForSubtask("afterAcsLogger");
            LogParameterUtil logParamUtil = new LogParameterUtil(record);
            logParamUtil.setStopWatch(sw_afterAcsLogger);
        }
        try {
            if (this.delegate != null) {
                this.delegate.log(record);
            } else {
                super.log(record);
            }
            if (!this.stats.getDisableStatistics().booleanValue()) {
                this.stats.incrementNumberOfMessages();
                float timeElapsedSinceLastStatistics = (float)(System.currentTimeMillis() - this.stats.getLastStatisticsRepportTime()) / 1000.0f;
                if (timeElapsedSinceLastStatistics >= (float)this.stats.getStatisticsCalculationPeriod()) {
                    this.stats.calculateLoggingStatistics();
                    this.stats.resetStatistics();
                    HashMap<String, String> addedData = new HashMap<String, String>();
                    addedData.put("StatisticsIdentification", this.stats.getStatisticsIdentification());
                    addedData.put("LoggerId", this.getName());
                    addedData.put("LastPeriodDuration", String.valueOf(this.stats.getActualStatisticsPeriod()));
                    addedData.put("LastPeriodNumberOfMessages", String.valueOf(this.stats.getLastPeriodNumberOfMessages()));
                    addedData.put("StatisticsGranularity", String.valueOf(this.stats.getStatisticsGranularity()));
                    addedData.put("MessageStatistics", String.valueOf(this.stats.getMessageStatistics()));
                    addedData.put("MessageIncrement", String.valueOf(this.stats.getMessageIncrement()));
                    addedData.put("LastPeriodNumberOfErrorMessages", String.valueOf(this.stats.getLastPeriodNumberOfLogErrors()));
                    addedData.put("ErrorMessageStatistics", String.valueOf(this.stats.getErrorStatistics()));
                    addedData.put("ErrorMessageIncrement", String.valueOf(this.stats.getErrorIncrement()));
                    AcsLogRecord logItem = this.createAcsLogRecord(Level.INFO, "LOGGING STATISTICS FOR: " + this.stats.getStatisticsIdentification() + "." + this.getName());
                    logItem.setParameters(new Object[]{addedData});
                    this.log(logItem);
                }
            }
        }
        catch (Exception e) {
            if (!this.stats.getDisableStatistics().booleanValue()) {
                this.stats.incrementNumberOfLogErrors();
                float timeElapsedSinceLastStatistics = (float)(System.currentTimeMillis() - this.stats.getLastStatisticsRepportTime()) / 1000.0f;
                if (timeElapsedSinceLastStatistics >= (float)this.stats.getStatisticsCalculationPeriod()) {
                    this.stats.calculateLoggingStatistics();
                    this.stats.resetStatistics();
                    HashMap<String, String> addedData = new HashMap<String, String>();
                    addedData.put("StatisticsIdentification", this.stats.getStatisticsIdentification());
                    addedData.put("LoggerId", this.getName());
                    addedData.put("LastPeriodDuration", String.valueOf(this.stats.getActualStatisticsPeriod()));
                    addedData.put("LastPeriodNumberOfMessages", String.valueOf(this.stats.getLastPeriodNumberOfMessages()));
                    addedData.put("StatisticsGranularity", String.valueOf(this.stats.getStatisticsGranularity()));
                    addedData.put("MessageStatistics", String.valueOf(this.stats.getMessageStatistics()));
                    addedData.put("MessageIncrement", String.valueOf(this.stats.getMessageIncrement()));
                    addedData.put("LastPeriodNumberOfErrorMessages", String.valueOf(this.stats.getLastPeriodNumberOfLogErrors()));
                    addedData.put("ErrorMessageStatistics", String.valueOf(this.stats.getErrorStatistics()));
                    addedData.put("ErrorMessageIncrement", String.valueOf(this.stats.getErrorIncrement()));
                    AcsLogRecord logItem = this.createAcsLogRecord(Level.INFO, "LOGGING STATISTICS FOR: " + this.stats.getStatisticsIdentification() + "." + this.getName());
                    logItem.setParameters(new Object[]{addedData});
                    this.log(logItem);
                }
            }
            System.out.println("CRITICAL LOGGER FAILURE in " + this.getLoggerName());
        }
        if (this.PROFILE) {
            sw_afterAcsLogger.stop();
            sw_all.stop();
            long elapsedNanos = sw_all.getLapTimeNanos();
            if (this.profileSlowestCallStopWatch == null || this.profileSlowestCallStopWatch.getLapTimeNanos() < elapsedNanos) {
                this.profileSlowestCallStopWatch = sw_all;
            }
            this.profileLogTimeStats.addValue((double)elapsedNanos);
            if (this.profileLogTimeStats.getN() >= 100L) {
                String msg = "Local logging times in ms for the last 100 logs: ";
                msg = msg + "mean=" + this.profileMillisecFormatter.format(this.profileLogTimeStats.getMean() * 1.0E-6);
                msg = msg + ", median=" + this.profileMillisecFormatter.format(this.profileLogTimeStats.getPercentile(50.0) * 1.0E-6);
                msg = msg + ", stdev=" + this.profileMillisecFormatter.format(this.profileLogTimeStats.getStandardDeviation() * 1.0E-6);
                msg = msg + "; details of slowest log (from ";
                msg = msg + IsoDateFormat.formatDate((Date)this.profileSlowestCallStopWatch.getStartTime()) + "): ";
                msg = msg + this.profileSlowestCallStopWatch.getSubtaskDetails();
                System.out.println(msg);
                this.profileSlowestCallStopWatch = null;
                this.profileLogTimeStats.clear();
            }
        }
    }

    @Override
    public void configureLogging(LogConfig newLogConfig) {
        if (newLogConfig == null) {
            throw new IllegalArgumentException("newLogConfig must not be null");
        }
        this.logConfig = newLogConfig;
        try {
            LogConfig.LockableUnnamedLogger config = this.logConfig.getNamedLoggerConfig(this.getLoggerName());
            if (this.DEBUG) {
                System.out.println("*** AcsLogger#configureLogging: name=" + this.getLoggerName() + " minLevel=" + config.getMinLogLevel() + " minLevelLocal=" + config.getMinLogLevelLocal());
            }
            this.configureLevels(config);
        }
        catch (Exception e) {
            this.log(Level.INFO, "Failed to configure logger.", e);
        }
        Filter logFilter = this.getFilter();
        if (logFilter != null && logFilter instanceof JacORBFilter) {
            ((JacORBFilter)logFilter).setLogLevel(this.getLevel());
        }
    }

    void configureLevels(UnnamedLogger loggerConfig) {
        try {
            AcsLogLevelDefinition minLogLevelACS = AcsLogLevelDefinition.fromXsdLogLevel(loggerConfig.getMinLogLevel().getType() < loggerConfig.getMinLogLevelLocal().getType() ? loggerConfig.getMinLogLevel() : loggerConfig.getMinLogLevelLocal());
            this.setLevel(AcsLogLevel.getLowestMatchingJdkLevel(minLogLevelACS));
        }
        catch (Exception ex) {
            this.log(Level.INFO, "Failed to configure logger.", ex);
        }
    }

    public void addLoggerClass(Class<?> loggerClass) {
        this.loggerClassNames.add(loggerClass.getName());
    }

    public void addIgnoreLogs(String className, String methodName) {
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName must not be null");
        }
        this.callStacksToBeIgnored.add(this.concatenateIgnoreLogData(className, methodName));
    }

    private final String concatenateIgnoreLogData(String className, String methodName) {
        return className + '#' + methodName;
    }

    public void closeLogger() {
        if (!this.stats.getDisableStatistics().booleanValue()) {
            this.stats.calculateLoggingStatistics();
            this.stats.resetStatistics();
            HashMap<String, String> addedData = new HashMap<String, String>();
            addedData.put("StatisticsIdentification", this.stats.getStatisticsIdentification());
            addedData.put("LoggerId", this.getName());
            addedData.put("LastPeriodDuration", String.valueOf(this.stats.getActualStatisticsPeriod()));
            addedData.put("LastPeriodNumberOfMessages", String.valueOf(this.stats.getLastPeriodNumberOfMessages()));
            addedData.put("StatisticsGranularity", String.valueOf(this.stats.getStatisticsGranularity()));
            addedData.put("MessageStatistics", String.valueOf(this.stats.getMessageStatistics()));
            addedData.put("MessageIncrement", String.valueOf(this.stats.getMessageIncrement()));
            addedData.put("LastPeriodNumberOfErrorMessages", String.valueOf(this.stats.getLastPeriodNumberOfLogErrors()));
            addedData.put("ErrorMessageStatistics", String.valueOf(this.stats.getErrorStatistics()));
            addedData.put("ErrorMessageIncrement", String.valueOf(this.stats.getErrorIncrement()));
            AcsLogRecord logItem = this.createAcsLogRecord(Level.INFO, "LOGGING STATISTICS FOR: " + this.stats.getStatisticsIdentification() + "." + this.getName());
            logItem.setParameters(new Object[]{addedData});
            this.log(logItem);
        }
    }
}

