/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging;

import alma.Logging.AcsLogServiceOperations;
import alma.Logging.XmlLogRecord;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.LogRecordComparator;
import alma.acs.logging.formatters.AcsLogFormatter;
import alma.acs.logging.formatters.AcsXMLLogFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;

class RemoteLogDispatcher {
    public static final String USE_ACS_LOGSERVICE_EXTENSIONS_PROPERTYNAME = "alma.acs.logging.useAcsLogServiceExtensions";
    public final boolean useAcsLogServiceExtensions = Boolean.getBoolean("alma.acs.logging.useAcsLogServiceExtensions");
    private int bufferSize = 30;
    private final ORB orb;
    private final AcsLogServiceOperations logService;
    private final AcsLogFormatter logFormatter;
    private LogRecordComparator timestampLogRecordComparator;
    private final boolean DEBUG = Boolean.getBoolean("alma.acs.logging.verbose");

    RemoteLogDispatcher(ORB orb, AcsLogServiceOperations logService, AcsLogFormatter logFormatter) {
        this.orb = orb;
        this.logService = logService;
        this.logFormatter = logFormatter;
        this.timestampLogRecordComparator = new LogRecordComparator(true);
        if (this.useAcsLogServiceExtensions && !(logFormatter instanceof AcsXMLLogFormatter)) {
            throw new RuntimeException("Only XML-based remote logging is supported with the alma.acs.logging.useAcsLogServiceExtensions option.");
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int newBuffSize) {
        if (newBuffSize >= 1) {
            this.bufferSize = newBuffSize;
        } else {
            System.out.println("RemoteLogDispatcher#setBufferSize: ignoring illegal value " + newBuffSize);
        }
    }

    FailedLogRecords sendLogRecords(LogRecord[] logRecords) {
        Arrays.sort(logRecords, this.timestampLogRecordComparator);
        FailedLogRecords failures = new FailedLogRecords();
        ArrayList<LogRecord> candidateLogRecords = new ArrayList<LogRecord>();
        if (this.useAcsLogServiceExtensions) {
            ArrayList<XmlLogRecord> remoteLogRecords = new ArrayList<XmlLogRecord>();
            for (int i = 0; i < logRecords.length; ++i) {
                if (i < this.getBufferSize()) {
                    try {
                        String xml = ((AcsXMLLogFormatter)this.logFormatter).format(logRecords[i]);
                        int level = AcsLogLevel.getNativeLevel((Level)logRecords[i].getLevel()).getAcsLevel().value;
                        XmlLogRecord remoteLogRecord = new XmlLogRecord(xml, (short)level);
                        remoteLogRecords.add(remoteLogRecord);
                        candidateLogRecords.add(logRecords[i]);
                    }
                    catch (RuntimeException e) {
                        failures.addSerializationFailure(logRecords[i]);
                    }
                    continue;
                }
                failures.addSendFailure(logRecords[i]);
            }
            if (!remoteLogRecords.isEmpty()) {
                XmlLogRecord[] remoteLogRecordsArray = remoteLogRecords.toArray(new XmlLogRecord[remoteLogRecords.size()]);
                this.writeRecords(remoteLogRecordsArray);
            }
        } else {
            ArrayList<Any> anyLogRecords = new ArrayList<Any>();
            for (int i = 0; i < logRecords.length; ++i) {
                if (i < this.getBufferSize()) {
                    try {
                        Any anyLogRecord = this.orb.create_any();
                        anyLogRecord = this.logFormatter.formatAny(anyLogRecord, logRecords[i]);
                        anyLogRecords.add(anyLogRecord);
                        candidateLogRecords.add(logRecords[i]);
                    }
                    catch (RuntimeException e) {
                        failures.addSerializationFailure(logRecords[i]);
                    }
                    continue;
                }
                failures.addSendFailure(logRecords[i]);
            }
            if (!anyLogRecords.isEmpty()) {
                Any[] anyLogRecordsArray = anyLogRecords.toArray(new Any[anyLogRecords.size()]);
                try {
                    this.writeRecords(anyLogRecordsArray);
                }
                catch (Throwable thr) {
                    failures.addSendFailures(candidateLogRecords);
                }
            }
        }
        return failures;
    }

    protected void writeRecords(Any[] anyLogRecordsArray) throws UserException {
        this.logService.write_records(anyLogRecordsArray);
        if (this.DEBUG) {
            System.out.println("sent the following Any log records to the log service:");
            for (int i = 0; i < anyLogRecordsArray.length; ++i) {
                System.out.println("" + i + ") " + anyLogRecordsArray[i].extract_string());
            }
        }
    }

    protected void writeRecords(XmlLogRecord[] remoteLogRecords) {
        this.logService.writeRecords(remoteLogRecords);
    }

    static class FailedLogRecords {
        private List<LogRecord> serializeFailures;
        private List<LogRecord> sendFailures;

        FailedLogRecords() {
        }

        void addSerializationFailure(LogRecord logRecord) {
            if (this.serializeFailures == null) {
                this.serializeFailures = new ArrayList<LogRecord>();
            }
            this.serializeFailures.add(logRecord);
        }

        void addSendFailure(LogRecord logRecord) {
            if (this.sendFailures == null) {
                this.sendFailures = new ArrayList<LogRecord>();
            }
            this.sendFailures.add(logRecord);
        }

        void addSendFailures(List<LogRecord> logRecords) {
            if (this.sendFailures == null) {
                this.sendFailures = new ArrayList<LogRecord>();
            }
            this.sendFailures.addAll(logRecords);
        }

        boolean hasSerializationFailures() {
            return this.serializeFailures != null;
        }

        List<LogRecord> getSerializationFailures() {
            if (this.serializeFailures == null) {
                return new ArrayList<LogRecord>(0);
            }
            return this.serializeFailures;
        }

        boolean hasSendFailures() {
            return this.sendFailures != null;
        }

        List<LogRecord> getSendFailures() {
            if (this.sendFailures == null) {
                return new ArrayList<LogRecord>(0);
            }
            return this.sendFailures;
        }
    }
}

