/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.adapters;

import alma.acs.util.IsoDateFormat;
import java.util.Date;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JacORBFilter
implements Filter {
    protected int logLevel = Level.ALL.intValue();

    @Override
    public boolean isLoggable(LogRecord record) {
        String message = record.getMessage();
        boolean isLoggable = true;
        if (record.getLevel().intValue() == Level.FINE.intValue()) {
            if (message.startsWith("POA ") && (message.endsWith("shutdown is in progress") || message.endsWith("destruction is apparent") || message.endsWith("clear up the queue...") || message.endsWith("... done") || message.endsWith("stop the request controller") || message.endsWith("etherialize all servants ..."))) {
                record.setLevel(Level.FINEST);
            } else if (message.startsWith("get_policy_overrides returns") || message.startsWith("read GIOP message of size") || message.startsWith("wrote GIOP message of size")) {
                record.setLevel(Level.FINEST);
            } else {
                isLoggable = !message.endsWith("_invoke: queuing request") && message.indexOf("is queued (queue size:") <= 0 && !message.endsWith("trying to get a RequestProcessor") && !message.endsWith("waiting for queue") && !message.endsWith("with request processing") && !message.endsWith("invokeOperation on servant (stream based)") && !message.endsWith("reset a previous completion call") && !message.startsWith("Delegate.getReference") && !message.startsWith("Received CodeSetContext. Using") && !message.startsWith("ClientConnectionManager: releasing ClientGIOPConnection") && !message.startsWith("Delegate released!") && !message.endsWith(": streamClosed()");
            }
        } else if (record.getLevel().intValue() == Level.INFO.intValue()) {
            if (message.indexOf("(C) The JacORB project") > 0 || message.startsWith("Received CloseConnection on ClientGIOPConnection") || message.startsWith("prepare ORB for shutdown") || message.startsWith("Client-side TCP transport to") || message.startsWith("ORB going down...") || message.startsWith("ORB run") || message.equals("ORB shutdown complete") || message.startsWith("POA ") && message.endsWith("destroyed") || message.startsWith("Opened new server-side TCP/IP")) {
                record.setLevel(Level.CONFIG);
            } else if (message.startsWith("Connected to ") || message.startsWith("Closed server-side transport to") || message.startsWith("POA ") && (message.endsWith("up the queue ...") || message.endsWith("... done")) || message.startsWith("Retrying to connect to") || message.startsWith("Negotiated char codeset of") || message.startsWith("ClientConnectionManager: created new ClientGIOPConnection") || message.startsWith("ClientConnectionManager: found ClientGIOPConnection") || message.startsWith("Initialising ORB with ID") || message.startsWith("Set default native char codeset to") || message.startsWith("Set default native wchar codeset to") || message.equals("Listener exiting") || message.equals("ConsumerTie exited")) {
                record.setLevel(Level.FINEST);
            } else if ((message.startsWith("ClientGIOPConnection to ") || message.startsWith("ServerGIOPConnection to ")) && message.contains(" BufferDump:\n") || message.startsWith("sendMessages(): ")) {
                String timeStamp = IsoDateFormat.formatDate((Date)new Date(record.getMillis()));
                System.out.println(timeStamp + " " + message);
                isLoggable = false;
            } else {
                isLoggable = !message.startsWith("oid: ") && !message.startsWith("InterceptorManager started with") && !message.startsWith("Using server ID (");
            }
        } else if (record.getLevel().intValue() == Level.WARNING.intValue()) {
            isLoggable = !message.startsWith("no adapter activator exists for");
        } else if (record.getLevel().intValue() == Level.SEVERE.intValue()) {
            boolean bl = isLoggable = !message.startsWith("no adapter activator exists for");
        }
        if (isLoggable && record.getLevel().intValue() < this.logLevel) {
            isLoggable = false;
        }
        if (isLoggable && message != null) {
            String message2 = null;
            int mlen = message.length();
            for (int i = 0; i < mlen; ++i) {
                char ch = message.charAt(i);
                if ((ch < ' ' || ch >= '\u007f') && ch != '\n' && ch != '\t') {
                    if (message2 == null) {
                        message2 = message.substring(0, i);
                    }
                    message2 = message2 + '#';
                    continue;
                }
                if (message2 == null) continue;
                message2 = message2 + ch;
            }
            if (message2 != null) {
                record.setMessage(message2);
            }
        }
        return isLoggable;
    }

    public void setLogLevel(Level level) {
        if (level != null) {
            this.logLevel = level.intValue();
        }
    }
}

