/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.config;

import alma.ACSErrTypeCommon.wrappers.AcsJIllegalArgumentEx;
import alma.acs.logging.AcsLogLevel;
import alma.acs.logging.config.LogConfigException;
import alma.acs.logging.config.LogConfigSubscriber;
import alma.acs.logging.level.AcsLogLevelDefinition;
import alma.acs.util.IsoDateFormat;
import alma.cdbErrType.CDBRecordDoesNotExistEx;
import alma.cdbErrType.CDBXMLErrorEx;
import alma.maci.loggingconfig.LoggingConfig;
import alma.maci.loggingconfig.NamedLogger;
import alma.maci.loggingconfig.UnnamedLogger;
import alma.maci.loggingconfig.types.LogLevel;
import com.cosylab.CDB.DALOperations;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.exolab.castor.core.exceptions.CastorException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LogConfig {
    public static final String PROPERTYNAME_MIN_LOG_LEVEL_LOCAL = "ACS.logstdout";
    public static final String PROPERTYNAME_MIN_LOG_LEVEL = "ACS.log.minlevel.remote";
    public static final String PROPERTYNAME_NAMED_LOGGER_LEVELS = "ACS.log.minlevel.namedloggers";
    static final String CDBNAME_LoggingConfig = LoggingConfig.class.getSimpleName();
    static final String CDBNAME_ComponentLogger = "ComponentLogger";
    private Logger logger;
    private DALOperations cdb;
    private String cdbLoggingConfigPath;
    private Map<String, String> cdbComponentPaths = new HashMap<String, String>();
    private LoggingConfig loggingConfig;
    private final Map<String, LockableUnnamedLogger> namedLoggerConfigs = new HashMap<String, LockableUnnamedLogger>();
    private final List<LogConfigSubscriber> subscriberList = new ArrayList<LogConfigSubscriber>();

    public LogConfig() {
        this.loggingConfig = new LoggingConfig();
        this.configureDefaultLevelsFromProperties();
    }

    private void configureDefaultLevelsFromProperties() {
        Integer minLevelValue;
        Integer minLevelLocalValue = Integer.getInteger(PROPERTYNAME_MIN_LOG_LEVEL_LOCAL);
        if (minLevelLocalValue != null) {
            try {
                this.loggingConfig.setMinLogLevelLocal(LogLevel.valueOf((String)minLevelLocalValue.toString()));
            }
            catch (IllegalArgumentException ex) {
                this.log(Level.INFO, "failed to pick up default stdout log level from property ACS.logstdout", ex);
            }
        }
        if ((minLevelValue = Integer.getInteger(PROPERTYNAME_MIN_LOG_LEVEL)) != null) {
            try {
                this.loggingConfig.setMinLogLevel(LogLevel.valueOf((String)minLevelValue.toString()));
            }
            catch (IllegalArgumentException ex) {
                this.log(Level.INFO, "failed to pick up default remote log level from property ACS.log.minlevel.remote", ex);
            }
        }
    }

    private void configureNamedLoggerLevelsFromProperties() {
        String propVal = System.getProperty(PROPERTYNAME_NAMED_LOGGER_LEVELS);
        if (propVal != null) {
            try {
                for (String levelDef : propVal.split(":")) {
                    String[] levelDefSplit = levelDef.split("=");
                    try {
                        String loggerName = levelDefSplit[0].trim();
                        String[] levels = levelDefSplit[1].split(",");
                        UnnamedLogger loggerConfig = new UnnamedLogger();
                        loggerConfig.setMinLogLevelLocal(AcsLogLevelDefinition.xsdLevelFromInteger(Integer.parseInt(levels[0])));
                        loggerConfig.setMinLogLevel(AcsLogLevelDefinition.xsdLevelFromInteger(Integer.parseInt(levels[1])));
                        this.storeNamedLoggerConfig(loggerName, new LockableUnnamedLogger(loggerConfig));
                        this.log(Level.INFO, "Set named logger levels from property. Name=" + loggerName + " local=" + loggerConfig.getMinLogLevelLocal() + " remote=" + loggerConfig.getMinLogLevel(), null);
                    }
                    catch (Exception ex) {
                        this.log(Level.WARNING, "Failed to process named logger level definition '" + levelDef + "' given in property '" + PROPERTYNAME_NAMED_LOGGER_LEVELS + "'. ", ex);
                    }
                }
            }
            catch (Exception ex) {
                this.log(Level.WARNING, "Failed to process named loggers from property ACS.log.minlevel.namedloggers", ex);
            }
        } else {
            this.log(Level.FINEST, "ACS.log.minlevel.namedloggers not defined.", null);
        }
    }

    public void setCDB(DALOperations cdb) {
        if (cdb != null) {
            this.cdb = cdb;
        } else {
            this.log(Level.FINE, "Ignoring call to setCDB(null)", null);
        }
    }

    public void setCDBLoggingConfigPath(String path) {
        this.cdbLoggingConfigPath = path;
    }

    public void setCDBComponentPath(String compLoggerName, String path) {
        this.cdbComponentPaths.put(compLoggerName, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(boolean cdbBeatsProperties) throws LogConfigException {
        LoggingConfig newLoggingConfig;
        StringBuffer errMsg;
        block26: {
            errMsg = new StringBuffer();
            newLoggingConfig = null;
            if (this.cdb != null) {
                try {
                    Object loggingConfigXml;
                    if (this.cdbLoggingConfigPath != null) {
                        loggingConfigXml = this.getLogConfigXml(this.cdbLoggingConfigPath, "//" + CDBNAME_LoggingConfig);
                        if (loggingConfigXml == null || ((String)loggingConfigXml).trim().isEmpty()) {
                            throw new LogConfigException("Node " + this.cdbLoggingConfigPath + " does not contain one LoggingConfig element.");
                        }
                        try {
                            newLoggingConfig = LoggingConfig.unmarshalLoggingConfig((Reader)new StringReader((String)loggingConfigXml));
                        }
                        catch (Throwable thr) {
                            this.log(Level.FINE, "Failed to unmarshal logging config xml '" + (String)loggingConfigXml + "'.", thr);
                            throw thr;
                        }
                    } else {
                        errMsg.append("CDB reference was set, but not the path to the logging configuration. ");
                    }
                    if (newLoggingConfig != null) {
                        this.loggingConfig = newLoggingConfig;
                        loggingConfigXml = this.namedLoggerConfigs;
                        synchronized (loggingConfigXml) {
                            for (String loggerName : this.namedLoggerConfigs.keySet()) {
                                this.storeNamedLoggerConfig(loggerName, null);
                            }
                            NamedLogger[] namedLoggers = this.loggingConfig.get();
                            for (int i = 0; i < namedLoggers.length; ++i) {
                                this.storeNamedLoggerConfig(namedLoggers[i].getName(), new LockableUnnamedLogger((UnnamedLogger)namedLoggers[i]));
                            }
                            for (String loggerName : this.cdbComponentPaths.keySet()) {
                                UnnamedLogger compLoggerConfig;
                                String xpath;
                                String cdbPath;
                                String componentConfigXML;
                                if (this.namedLoggerConfigs.containsKey(loggerName) || (componentConfigXML = this.getLogConfigXml(cdbPath = this.cdbComponentPaths.get(loggerName), xpath = "//_[@Name='" + loggerName + "']/" + CDBNAME_ComponentLogger)) == null) continue;
                                try {
                                    compLoggerConfig = UnnamedLogger.unmarshalUnnamedLogger((Reader)new StringReader(componentConfigXML));
                                }
                                catch (Throwable thr) {
                                    this.log(Level.FINE, "Failed to unmarshal component config xml '" + componentConfigXML + "'.", thr);
                                    throw thr;
                                }
                                this.storeNamedLoggerConfig(loggerName, new LockableUnnamedLogger(compLoggerConfig));
                            }
                            break block26;
                        }
                    }
                    throw new LogConfigException("LoggingConfig binding class obtained from CDB node '" + this.cdbLoggingConfigPath + "' was null.");
                }
                catch (CDBXMLErrorEx ex) {
                    errMsg.append("Failed to read node " + this.cdbLoggingConfigPath + " from the CDB (msg='" + ex.errorTrace.shortDescription + "'). ");
                }
                catch (CDBRecordDoesNotExistEx ex) {
                    errMsg.append("Node " + this.cdbLoggingConfigPath + " does not exist in the CDB (msg='" + ex.errorTrace.shortDescription + "'). ");
                }
                catch (CastorException ex) {
                    errMsg.append("Failed to parse XML for CDB node " + this.cdbLoggingConfigPath + " into binding classes (ex=" + ((Object)((Object)ex)).getClass().getName() + ", msg='" + ex.getMessage() + "'). ");
                }
                catch (Throwable thr) {
                    errMsg.append("Failed to read node " + this.cdbLoggingConfigPath + " from the CDB (ex=" + thr.getClass().getName() + ", msg='" + thr.getMessage() + "'). ");
                }
            }
        }
        if (this.cdb == null || !cdbBeatsProperties) {
            this.configureDefaultLevelsFromProperties();
            this.configureNamedLoggerLevelsFromProperties();
        }
        this.notifySubscribers();
        if (newLoggingConfig != null) {
            StringWriter writer = new StringWriter();
            String newXML = null;
            try {
                newLoggingConfig.marshal((Writer)writer);
                newXML = writer.toString().trim();
            }
            catch (Throwable i) {
                // empty catch block
            }
            String msg = "Updated logging configuration based on CDB entry " + newXML;
            msg = msg + " with " + (cdbBeatsProperties ? "CDB" : "env vars") + " having precedence over " + (cdbBeatsProperties ? "env vars" : "CDB");
            this.log(Level.FINER, msg, null);
        } else {
            this.log(Level.FINER, "Logging configuration has been initialized, but not from CDB settings.", null);
        }
        if (errMsg.length() > 0) {
            throw new LogConfigException("Log config initialization at least partially failed. " + errMsg.toString());
        }
    }

    String getLogConfigXml(String cdbPathParent, String xpathLogConfigNode) throws CDBXMLErrorEx, CDBRecordDoesNotExistEx, ParserConfigurationException, SAXException, IOException, XPathExpressionException, TransformerException {
        Document parentDoc;
        if (this.cdb == null) {
            throw new IllegalStateException("CDB reference has not been set.");
        }
        String parentConfigXML = this.cdb.get_DAO(cdbPathParent);
        Node loggingConfigElement = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        try {
            parentDoc = builder.parse(new InputSource(new StringReader(parentConfigXML)));
        }
        catch (SAXException ex) {
            String msg = "Failed to parse the following XML retrieved from CDB#get_DAO(" + cdbPathParent + "):\n" + parentConfigXML;
            this.log(Level.FINE, msg, ex);
            throw ex;
        }
        String encoding = parentDoc.getXmlEncoding();
        Element rootElement = parentDoc.getDocumentElement();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Object xpathResult = xpath.evaluate(xpathLogConfigNode, rootElement, XPathConstants.NODE);
        if (xpathResult == null || !(xpathResult instanceof Node)) {
            return null;
        }
        loggingConfigElement = (Node)xpathResult;
        Document childDoc = builder.newDocument();
        loggingConfigElement = childDoc.importNode(loggingConfigElement, true);
        childDoc.appendChild(loggingConfigElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", encoding);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(new DOMSource(childDoc), result);
        return sw.toString();
    }

    public String getCentralizedLogger() {
        return this.loggingConfig.getCentralizedLogger();
    }

    public int getDispatchPacketSize() {
        return this.loggingConfig.getDispatchPacketSize();
    }

    public AcsLogLevelDefinition getImmediateDispatchLevel() {
        return this.convertLegalLogLevel(this.loggingConfig.getImmediateDispatchLevel());
    }

    public int getFlushPeriodSeconds() {
        return this.loggingConfig.getFlushPeriodSeconds();
    }

    public int getMaxLogQueueSize() {
        return this.loggingConfig.getMaxLogQueueSize();
    }

    public int getMaxLogsPerSecond() {
        return this.loggingConfig.getMaxLogsPerSecond();
    }

    public void setMaxLogsPerSecond(int maxLogsPerSecond) {
        this.loggingConfig.setMaxLogsPerSecond(maxLogsPerSecond);
        this.notifySubscribers();
    }

    private AcsLogLevelDefinition convertLegalLogLevel(LogLevel legalLogLevel) {
        try {
            return AcsLogLevelDefinition.fromXsdLogLevel(legalLogLevel);
        }
        catch (AcsJIllegalArgumentEx ex) {
            this.log(Level.WARNING, "Failed to convert to AcsLogLevelDefinition the level integer " + legalLogLevel, ex);
            throw new RuntimeException(ex);
        }
    }

    public AcsLogLevelDefinition getDefaultMinLogLevelLocal() {
        return this.convertLegalLogLevel(this.loggingConfig.getMinLogLevelLocal());
    }

    public void setDefaultMinLogLevelLocal(AcsLogLevelDefinition newLevel) {
        if (newLevel.value >= 0) {
            this.loggingConfig.setMinLogLevelLocal(newLevel.toXsdLevel());
            this.notifySubscribers();
        }
    }

    public AcsLogLevelDefinition getDefaultMinLogLevel() {
        return this.convertLegalLogLevel(this.loggingConfig.getMinLogLevel());
    }

    public void setDefaultMinLogLevel(AcsLogLevelDefinition newLevel) {
        if (newLevel.value >= 0) {
            this.loggingConfig.setMinLogLevel(newLevel.toXsdLevel());
            this.notifySubscribers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLoggerNames() {
        Map<String, LockableUnnamedLogger> map = this.namedLoggerConfigs;
        synchronized (map) {
            return new HashSet<String>(this.namedLoggerConfigs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnownLogger(String loggerName) {
        Map<String, LockableUnnamedLogger> map = this.namedLoggerConfigs;
        synchronized (map) {
            return this.namedLoggerConfigs.containsKey(loggerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCustomConfig(String loggerName) {
        Map<String, LockableUnnamedLogger> map = this.namedLoggerConfigs;
        synchronized (map) {
            return this.namedLoggerConfigs.get(loggerName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockableUnnamedLogger getNamedLoggerConfig(String loggerName) {
        LockableUnnamedLogger ret = new LockableUnnamedLogger();
        Map<String, LockableUnnamedLogger> map = this.namedLoggerConfigs;
        synchronized (map) {
            if (loggerName == null || loggerName.toLowerCase().equals("default") || this.namedLoggerConfigs.get(loggerName) == null) {
                ret.setMinLogLevel(this.loggingConfig.getMinLogLevel());
                ret.setMinLogLevelLocal(this.loggingConfig.getMinLogLevelLocal());
                if (loggerName != null && !loggerName.toLowerCase().equals("default")) {
                    this.storeNamedLoggerConfig(loggerName, null);
                }
            } else {
                ret = new LockableUnnamedLogger(this.namedLoggerConfigs.get(loggerName));
            }
        }
        return ret;
    }

    public void setNamedLoggerConfig(String loggerName, LockableUnnamedLogger config) throws AcsJIllegalArgumentEx {
        if (loggerName != null && config != null) {
            AcsLogLevelDefinition.fromXsdLogLevel(config.getMinLogLevel());
            AcsLogLevelDefinition.fromXsdLogLevel(config.getMinLogLevelLocal());
            LockableUnnamedLogger config2 = new LockableUnnamedLogger(config);
            this.storeNamedLoggerConfig(loggerName, config2);
            this.notifySubscribers();
        }
    }

    public void setNamedLoggerConfig(String loggerName, UnnamedLogger config) throws AcsJIllegalArgumentEx {
        if (loggerName != null && config != null) {
            LockableUnnamedLogger config2 = new LockableUnnamedLogger(config);
            this.setNamedLoggerConfig(loggerName, config2);
        }
    }

    public void clearNamedLoggerConfig(String loggerName) {
        if (loggerName != null) {
            this.storeNamedLoggerConfig(loggerName, null);
            this.notifySubscribers();
        }
    }

    public void setMinLogLevelLocal(AcsLogLevelDefinition newLevel, String loggerName) {
        LockableUnnamedLogger config = this.getNamedLoggerConfig(loggerName);
        config.setMinLogLevelLocal(newLevel.toXsdLevel());
        try {
            this.setNamedLoggerConfig(loggerName, config);
        }
        catch (AcsJIllegalArgumentEx acsJIllegalArgumentEx) {
            // empty catch block
        }
    }

    public void setMinLogLevel(AcsLogLevelDefinition newLevel, String loggerName) {
        LockableUnnamedLogger config = this.getNamedLoggerConfig(loggerName);
        config.setMinLogLevel(newLevel.toXsdLevel());
        try {
            this.setNamedLoggerConfig(loggerName, config);
        }
        catch (AcsJIllegalArgumentEx acsJIllegalArgumentEx) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAndLockMinLogLevel(AcsLogLevelDefinition newLevel, String loggerName) {
        Map<String, LockableUnnamedLogger> map = this.namedLoggerConfigs;
        synchronized (map) {
            LockableUnnamedLogger config = this.getNamedLoggerConfig(loggerName);
            if (config.isLockedRemote()) {
                if (!newLevel.isEqualXsdLevel(config.getMinLogLevel())) {
                    this.log(Level.WARNING, "Ignoring attempt to lock logger " + loggerName + " to level " + (Object)((Object)newLevel) + " because it is already locked to remote level " + config.getMinLogLevel(), null);
                }
            } else if (!newLevel.isEqualXsdLevel(config.getMinLogLevel())) {
                config.setMinLogLevel(newLevel.toXsdLevel());
                config.lockRemote();
                try {
                    this.setNamedLoggerConfig(loggerName, config);
                }
                catch (AcsJIllegalArgumentEx acsJIllegalArgumentEx) {
                    // empty catch block
                }
                this.log(Level.INFO, "Locked logger " + loggerName + " to remote level " + newLevel.value, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeNamedLoggerConfig(String loggerName, LockableUnnamedLogger config) {
        if (loggerName == null) {
            throw new IllegalArgumentException("loggerName must not be null");
        }
        Map<String, LockableUnnamedLogger> map = this.namedLoggerConfigs;
        synchronized (map) {
            LockableUnnamedLogger oldConfig = this.namedLoggerConfigs.get(loggerName);
            if (oldConfig == null) {
                this.namedLoggerConfigs.put(loggerName, config);
            } else if (config == null) {
                if (!oldConfig.isLockedLocal && !oldConfig.isLockedRemote) {
                    this.namedLoggerConfigs.put(loggerName, null);
                } else {
                    this.log(Level.INFO, "Ignoring attempt to clear locked logger config for " + loggerName, null);
                }
            } else {
                if (!oldConfig.isLockedRemote()) {
                    oldConfig.setMinLogLevel(config.getMinLogLevel());
                }
                if (!oldConfig.isLockedLocal()) {
                    oldConfig.setMinLogLevelLocal(config.getMinLogLevelLocal());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameNamedLoggerConfig(String oldLoggerName, String newLoggerName) {
        Map<String, LockableUnnamedLogger> map = this.namedLoggerConfigs;
        synchronized (map) {
            if (oldLoggerName == null || newLoggerName == null || !this.namedLoggerConfigs.containsKey(oldLoggerName)) {
                return false;
            }
            LockableUnnamedLogger config = this.namedLoggerConfigs.get(oldLoggerName);
            this.namedLoggerConfigs.put(newLoggerName, config);
            this.namedLoggerConfigs.remove(oldLoggerName);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(LogConfigSubscriber subscriber) {
        List<LogConfigSubscriber> list = this.subscriberList;
        synchronized (list) {
            if (!this.subscriberList.contains(subscriber)) {
                this.subscriberList.add(subscriber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySubscribers() {
        List<LogConfigSubscriber> list = this.subscriberList;
        synchronized (list) {
            for (LogConfigSubscriber subscriber : this.subscriberList) {
                subscriber.configureLogging(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(LogConfigSubscriber subscriber) {
        List<LogConfigSubscriber> list = this.subscriberList;
        synchronized (list) {
            this.subscriberList.remove(subscriber);
        }
    }

    public void setInternalLogger(Logger logger) {
        this.logger = logger;
    }

    protected void log(Level level, String msg, Throwable thr) {
        if (this.logger != null) {
            this.logger.log(level, msg, thr);
        } else if (AcsLogLevel.getNativeLevel(level).getAcsLevel().compareTo(this.getDefaultMinLogLevelLocal()) >= 0) {
            System.out.println(IsoDateFormat.formatCurrentDate() + " " + AcsLogLevel.getNativeLevel(level).getAcsLevel().toString() + " [alma.acs.logging.config.LogConfig] " + msg + (thr != null ? thr.toString() : ""));
        }
    }

    public static class LockableUnnamedLogger
    extends UnnamedLogger {
        private boolean isLockedRemote = false;
        private boolean isLockedLocal = false;

        LockableUnnamedLogger() {
            this.init(null);
        }

        LockableUnnamedLogger(UnnamedLogger config) {
            this.init(config);
        }

        LockableUnnamedLogger(LockableUnnamedLogger config) {
            this.init(config);
            this.isLockedRemote = config.isLockedRemote;
            this.isLockedLocal = config.isLockedLocal;
        }

        private void init(UnnamedLogger config) {
            this.unlockRemote();
            if (config != null) {
                this.setMinLogLevel(config.getMinLogLevel());
                this.setMinLogLevelLocal(config.getMinLogLevelLocal());
            }
        }

        void lockRemote() {
            this.isLockedRemote = true;
        }

        void lockLocal() {
            this.isLockedLocal = true;
        }

        void unlockRemote() {
            this.isLockedRemote = false;
        }

        void unlockLocal() {
            this.isLockedLocal = false;
        }

        boolean isLockedRemote() {
            return this.isLockedRemote;
        }

        boolean isLockedLocal() {
            return this.isLockedLocal;
        }
    }
}

