/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.formatters;

import alma.acs.logging.LogParameterUtil;
import alma.acs.util.IsoDateFormat;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ConsoleLogFormatter
extends Formatter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private final Date date = new Date();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(128);
        Date date = this.date;
        synchronized (date) {
            this.date.setTime(record.getMillis());
            sb.append(IsoDateFormat.formatDate((Date)this.date));
        }
        sb.append(' ');
        sb.append(record.getLevel().getLocalizedName());
        String sourceObject = record.getLoggerName();
        if (sourceObject != null) {
            sb.append(" [").append(sourceObject).append("] ");
        }
        sb.append(record.getMessage());
        LogParameterUtil logParamUtil = new LogParameterUtil(record);
        String paramString = "";
        for (Object param : logParamUtil.getNonSpecialPropertiesMapParameters()) {
            if (param instanceof Map) {
                Map propertiesMap = (Map)param;
                for (Object keyName : propertiesMap.keySet()) {
                    String value = propertiesMap.get(keyName).toString();
                    paramString = paramString + keyName + "='" + value + "' ";
                }
                continue;
            }
            String value = param.toString();
            paramString = paramString + "LoggedParameter='" + value + "' ";
        }
        if (!paramString.isEmpty()) {
            sb.append(" [ " + paramString + "]");
        }
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new String(sb);
    }
}

