/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.net.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;

public class URIUtils {
    private static final String FILE_PROTOCOL_PREFIX = "file:///";
    private static final char HREF_PATH_SEP = '/';
    private static final String URL_PATH_SEP_STR = "/";
    private static final char DEVICE_SEP = '|';
    private static final String CURRENT_DIR_OP = ".";
    private static final String PARENT_DIR_OP = "..";
    private static final String DOT_SLASH = "./";

    public static InputStream getInputStream(String href, String documentBase) throws FileNotFoundException, IOException {
        URL url = null;
        try {
            url = new URL(href);
            return url.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            int idx22;
            String xHref = null;
            xHref = documentBase != null && documentBase.length() > 0 ? ((idx22 = documentBase.lastIndexOf(47)) == documentBase.length() - 1 ? documentBase + href : documentBase + '/' + href) : href;
            try {
                url = new URL(xHref);
                return url.openStream();
            }
            catch (MalformedURLException idx22) {
                File iFile = new File(href);
                if (iFile.isAbsolute()) {
                    return new FileInputStream(iFile);
                }
                iFile = new File(xHref);
                return new FileInputStream(iFile);
            }
        }
    }

    public static Reader getReader(String href, String documentBase) throws FileNotFoundException, IOException {
        InputStream is = URIUtils.getInputStream(href, documentBase);
        return new InputStreamReader(is);
    }

    public static String getDocumentBase(String href) {
        int idx;
        String docBase;
        block4: {
            docBase = "";
            if (href == null) {
                return docBase;
            }
            idx = -1;
            try {
                URL url = new URL(href);
                url = null;
                idx = href.lastIndexOf(47);
            }
            catch (MalformedURLException muex) {
                int idx2 = href.lastIndexOf(47);
                idx = href.lastIndexOf(File.separator);
                if (idx2 <= idx) break block4;
                idx = idx2;
            }
        }
        if (idx >= 0) {
            docBase = href.substring(0, idx);
        }
        return docBase;
    }

    public static String getRelativeURI(String href) {
        int idx;
        block4: {
            if (href == null) {
                return href;
            }
            idx = -1;
            try {
                URL url = new URL(href);
                url = null;
                idx = href.lastIndexOf(47);
            }
            catch (MalformedURLException muex) {
                int idx2 = href.lastIndexOf(47);
                idx = href.lastIndexOf(File.separator);
                if (idx2 <= idx) break block4;
                idx = idx2;
            }
        }
        if (idx >= 0) {
            return href.substring(idx + 1);
        }
        return href;
    }

    public static String normalize(String absoluteURL) throws MalformedURLException {
        if (absoluteURL == null) {
            return absoluteURL;
        }
        if (absoluteURL.indexOf(46) < 0) {
            return absoluteURL;
        }
        Stack<String> tokens = new Stack<String>();
        StringTokenizer st = new StringTokenizer(absoluteURL, URL_PATH_SEP_STR, true);
        String last = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (URL_PATH_SEP_STR.equals(token)) {
                if (URL_PATH_SEP_STR.equals(last)) {
                    tokens.push("");
                }
            } else if (PARENT_DIR_OP.equals(token)) {
                if (tokens.empty()) {
                    throw new MalformedURLException("invalid absolute URL: " + absoluteURL);
                }
                tokens.pop();
            } else if (!CURRENT_DIR_OP.equals(token)) {
                tokens.push(token);
            }
            last = token;
        }
        StringBuffer buffer = new StringBuffer(absoluteURL.length());
        for (int i = 0; i < tokens.size(); ++i) {
            if (i > 0) {
                buffer.append('/');
            }
            buffer.append(tokens.elementAt(i).toString());
        }
        return buffer.toString();
    }

    public static String resolveAsString(String href, String documentBase) {
        try {
            URL url = new URL(href);
            url = null;
            return href;
        }
        catch (MalformedURLException url) {
            int idx;
            String absolute = null;
            absolute = documentBase != null && documentBase.length() > 0 ? ((idx = documentBase.lastIndexOf(47)) == documentBase.length() - 1 ? documentBase + href : documentBase + '/' + href) : href;
            try {
                if (absolute.indexOf(DOT_SLASH) >= 0) {
                    absolute = URIUtils.normalize(absolute);
                }
                URL url2 = new URL(absolute);
                url2 = null;
                return absolute;
            }
            catch (MalformedURLException muex) {
                int idx2 = absolute.indexOf(58);
                if (idx2 >= 0) {
                    String scheme = absolute.substring(0, idx2);
                    String error = "unknown protocol: " + scheme;
                    if (error.equals(muex.getMessage())) {
                        return absolute;
                    }
                }
                String fileURL = absolute;
                File iFile = new File(href);
                boolean exists = iFile.exists();
                fileURL = URIUtils.createFileURL(iFile.getAbsolutePath());
                if (!(iFile.isAbsolute() || !(iFile = new File(absolute)).exists() && exists)) {
                    fileURL = URIUtils.createFileURL(iFile.getAbsolutePath());
                }
                try {
                    URL url3 = new URL(fileURL);
                    url3 = null;
                    return fileURL;
                }
                catch (MalformedURLException malformedURLException) {
                    return absolute;
                }
            }
        }
    }

    private static String createFileURL(String filename) {
        if (filename == null) {
            return FILE_PROTOCOL_PREFIX;
        }
        int size = filename.length() + FILE_PROTOCOL_PREFIX.length();
        StringBuffer sb = new StringBuffer(size);
        sb.append(FILE_PROTOCOL_PREFIX);
        char[] chars = filename.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\\': {
                    sb.append('/');
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

