/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.types.BaseDescriptor;
import org.exolab.castor.types.Date;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLFieldHandler;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;

public class DateDescriptor
extends BaseDescriptor {
    private static final String _xmlName = "date";
    private static XMLFieldDescriptorImpl _contentDescriptor = null;
    private static FieldDescriptor[] _fields = null;

    public DateDescriptor() {
        super(_xmlName, Date.class);
        if (_contentDescriptor == null) {
            _contentDescriptor = new XMLFieldDescriptorImpl(String.class, "content", "content", NodeType.Text);
            _contentDescriptor.setHandler(new DateFieldHandler());
        }
        if (_fields == null) {
            _fields = new FieldDescriptor[1];
            DateDescriptor._fields[0] = _contentDescriptor;
        }
    }

    @Override
    public XMLFieldDescriptor getContentDescriptor() {
        return _contentDescriptor;
    }

    @Override
    public FieldDescriptor[] getFields() {
        return _fields;
    }

    class DateFieldHandler
    extends XMLFieldHandler {
        @Override
        public Object getValue(Object target) throws IllegalStateException {
            Date date = (Date)target;
            return date.toString();
        }

        @Override
        public void setValue(Object target, Object value) throws IllegalStateException {
            if (!(target instanceof Date)) {
                String err = "DateDescriptor#setValue: expected Date, received instead:" + target.getClass();
                throw new IllegalStateException(err);
            }
            Date dateTarget = (Date)target;
            if (value == null) {
                String err = "DateDescriptor#setValue: null value.";
                throw new IllegalStateException(err);
            }
            try {
                Date temp = Date.parseDate(value.toString());
                dateTarget.setCentury(temp.getCentury());
                dateTarget.setYear(temp.getYear());
                dateTarget.setMonth(temp.getMonth());
                dateTarget.setDay(temp.getDay());
                if (temp.isUTC()) {
                    dateTarget.setUTC();
                    dateTarget.setZone(temp.getZoneHour(), temp.getZoneMinute());
                    if (temp.isZoneNegative()) {
                        dateTarget.setZoneNegative(true);
                    }
                }
            }
            catch (ParseException ex) {
                String err = "DateDescriptor#setValue: wrong value\n" + ex.getMessage();
                throw new IllegalStateException(err);
            }
        }

        @Override
        public void resetValue(Object target) throws IllegalStateException {
        }

        @Override
        public void checkValidity(Object object) throws ValidityException, IllegalStateException {
        }

        @Override
        public Object newInstance(Object parent) throws IllegalStateException {
            return new Date();
        }
    }
}

