/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;

class DeferredSimpleType
extends SimpleType {
    private SimpleType instance = null;
    private String baseTypeName = null;
    private int createInstanceCallsCount = 0;

    DeferredSimpleType() {
    }

    DeferredSimpleType(String name) {
        this.setName(name);
    }

    DeferredSimpleType(String name, Schema schema) {
        this.setName(name);
        this.setSchema(schema);
    }

    public void setBaseTypeName(String baseTypeName) {
        this.baseTypeName = baseTypeName;
    }

    @Override
    XMLType getType() {
        if (this.instance == null) {
            this.createInstance();
        }
        return this.instance;
    }

    protected synchronized void createInstance() {
        ++this.createInstanceCallsCount;
        if (this.createInstanceCallsCount >= 666) {
            String err = "cyclic type definition involving the type: " + this.getName();
            throw new IllegalStateException(err);
        }
        this.instance = Schema.getTypeFactory().createUserSimpleType(this.getSchema(), this.getName(), this.baseTypeName, this.getDerivationMethod(), false);
        if (this.instance != null) {
            this.copyFacets(this.instance);
            this.instance.setParent(this.getParent());
        }
    }

    @Override
    public short getStructureType() {
        return -1;
    }
}

