/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Structure;

public class Wildcard
extends Particle {
    private Vector _namespaces;
    private boolean _attribute = false;
    private ComplexType _complexType;
    private Group _group;
    private AttributeGroup _attGroup;
    private String _processContents;
    private String _id = null;

    public Wildcard(ComplexType complexType) {
        this._complexType = complexType;
        this.init();
    }

    public Wildcard(Group group) {
        this._group = group;
        this.init();
    }

    public Wildcard(AttributeGroup attGroup) {
        this._attGroup = attGroup;
        this.init();
    }

    private void init() {
        this._namespaces = new Vector(1);
        this.setMaxOccurs(1);
        this.setMinOccurs(1);
        try {
            this.setProcessContents("strict");
        }
        catch (SchemaException schemaException) {
            // empty catch block
        }
    }

    public void addNamespace(String Namespace2) {
        this._namespaces.addElement(Namespace2);
    }

    public boolean removeNamespace(String namespace) {
        if (namespace == null) {
            return false;
        }
        int position = this._namespaces.indexOf(namespace);
        if (position >= 0) {
            this._namespaces.removeElementAt(position);
            return true;
        }
        return false;
    }

    public ComplexType getComplexType() {
        return this._complexType;
    }

    public Group getModelGroup() {
        return this._group;
    }

    public AttributeGroup getAttributeGroup() {
        return this._attGroup;
    }

    public Schema getSchema() {
        if (this._complexType != null) {
            return this._complexType.getSchema();
        }
        if (this._attGroup != null) {
            if (this._attGroup instanceof AttributeGroupDecl) {
                return ((AttributeGroupDecl)this._attGroup).getSchema();
            }
            if (this._attGroup instanceof AttributeGroupReference) {
                AttributeGroup tempRef = ((AttributeGroupReference)this._attGroup).resolveReference();
                if (tempRef instanceof AttributeGroupDecl) {
                    return ((AttributeGroupDecl)tempRef).getSchema();
                }
                tempRef = null;
                return null;
            }
        } else if (this._group != null) {
            Structure parent = this._group.getParent();
            Schema result = null;
            if (parent != null) {
                block5: while (result == null) {
                    switch (parent.getStructureType()) {
                        case 6: {
                            result = ((ComplexType)parent).getSchema();
                            continue block5;
                        }
                        case 16: {
                            result = ((ModelGroup)parent).getSchema();
                            continue block5;
                        }
                        case 10: {
                            parent = ((Group)parent).getParent();
                            continue block5;
                        }
                    }
                    String err = "A group can only be child of a complexType";
                    err = err + " or a ModelGroup or a group.";
                    throw new IllegalStateException(err);
                }
            }
            return result;
        }
        return null;
    }

    public Enumeration getNamespaces() {
        return this._namespaces.elements();
    }

    public String getProcessContent() {
        return this._processContents;
    }

    public boolean isAttributeWildcard() {
        return this._attribute;
    }

    public void setAttributeWildcard() {
        this._attribute = true;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setProcessContents(String process) throws SchemaException {
        if (!SchemaNames.isProcessName(process)) {
            throw new SchemaException("processContents attribute not valid:" + process);
        }
        this._processContents = process;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public short getStructureType() {
        return 24;
    }
}

