/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class AttributeGroupUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private AttributeGroup _attributeGroup = null;
    private boolean allowAnnotation = true;
    private boolean foundAnyAttribute = false;
    private boolean isRef = false;
    private boolean requireName = false;
    private Schema _schema = null;

    /*
     * Enabled aggressive block sorting
     */
    public AttributeGroupUnmarshaller(Schema schema, AttributeSet atts) throws XMLException {
        this._schema = schema;
        String ref = atts.getValue("ref");
        if (ref == null) {
            AttributeGroupDecl attDecl = new AttributeGroupDecl(schema);
            this._attributeGroup = attDecl;
            attDecl.setName(atts.getValue("name"));
            attDecl.setId(atts.getValue("id"));
            return;
        }
        if (ref.length() > 0) {
            this.isRef = true;
            this._attributeGroup = new AttributeGroupReference(schema, ref);
            return;
        }
        String err = "The value of the 'ref' attribute for attribute group must contain a valid value.";
        throw new SchemaException(err);
    }

    @Override
    public String elementName() {
        return "attributeGroup";
    }

    public AttributeGroup getAttributeGroup() {
        return this._attributeGroup;
    }

    @Override
    public Object getObject() {
        return this.getAttributeGroup();
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("anyAttribute".equals(name)) {
            if (this.foundAnyAttribute) {
                this.error("an anyAttribute element can appear only once as a child of an 'AttributeGroup'.");
            }
            this.foundAnyAttribute = true;
            this.allowAnnotation = true;
            this.unmarshaller = new WildcardUnmarshaller(this._attributeGroup, this._schema, name, atts, this.getResolver());
        } else if ("attribute".equals(name)) {
            this.allowAnnotation = false;
            if (this.isRef) {
                this.error("AttributeGroup references may not have children.");
            }
            this.unmarshaller = new AttributeUnmarshaller(this._schema, atts, this.getResolver());
        } else if ("attributeGroup".equals(name)) {
            this.allowAnnotation = false;
            if (this.isRef) {
                this.error("AttributeGroup references may not have children.");
            }
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, atts);
        } else if (name.equals("annotation")) {
            if (!this.allowAnnotation) {
                this.outOfOrder(name);
            }
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else {
            this.illegalElement(name);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("anyAttribute".equals(name)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                ((AttributeGroupDecl)this._attributeGroup).setAnyAttribute(wildcard);
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if ("attribute".equals(name)) {
            AttributeDecl attrDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            ((AttributeGroupDecl)this._attributeGroup).addAttribute(attrDecl);
        } else if ("attributeGroup".equals(name)) {
            Object obj = this.unmarshaller.getObject();
            try {
                ((AttributeGroupDecl)this._attributeGroup).addReference((AttributeGroupReference)obj);
            }
            catch (ClassCastException ex) {
                String err = "AttributeGroups cannot contain new AttributeGroup definitions, only references to top-level AttributeGroups are allowed.";
                this.error(err);
            }
        } else if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._attributeGroup.addAnnotation(ann);
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

