/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;

public class FacetUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller = null;
    private int depth = 0;
    private Facet _facet = null;
    private String _elementName = null;

    public FacetUnmarshaller(String name, AttributeSet atts) throws XMLException {
        this._elementName = name;
        if (!FacetUnmarshaller.isFacet(name)) {
            String err = "'" + name + "' is not a valid or supported facet.";
            throw new IllegalArgumentException(err);
        }
        Object attValue = null;
        this._facet = new Facet(name, atts.getValue("value"));
    }

    @Override
    public String elementName() {
        return this._elementName;
    }

    public Facet getFacet() {
        return this._facet;
    }

    @Override
    public Object getObject() {
        return this.getFacet();
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("annotation".equals(name)) {
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        if (this.unmarshaller == null) {
            throw new SchemaException("missing start element: " + name);
        }
        if ("annotation".equals(name)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._facet.addAnnotation(annotation);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }

    protected static boolean isFacet(String name) {
        if ("enumeration".equals(name)) {
            return true;
        }
        if ("length".equals(name)) {
            return true;
        }
        if ("pattern".equals(name)) {
            return true;
        }
        if ("maxExclusive".equals(name)) {
            return true;
        }
        if ("minExclusive".equals(name)) {
            return true;
        }
        if ("maxInclusive".equals(name)) {
            return true;
        }
        if ("minInclusive".equals(name)) {
            return true;
        }
        if ("maxLength".equals(name)) {
            return true;
        }
        if ("minLength".equals(name)) {
            return true;
        }
        if ("whiteSpace".equals(name)) {
            return true;
        }
        if ("totalDigits".equals(name)) {
            return true;
        }
        return "fractionDigits".equals(name);
    }
}

