/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;

public class FieldOrSelectorUnmarshaller
extends ComponentReader {
    private ComponentReader _unmarshaller;
    private int _depth = 0;
    private Annotated _fieldOrSelector = null;
    private boolean _foundAnnotation = false;
    private String _elementName = null;

    public FieldOrSelectorUnmarshaller(String elementName, AttributeSet atts) throws XMLException {
        this._elementName = elementName;
        String xpath = atts.getValue("xpath");
        if (xpath == null) {
            this.error("The 'xpath' attribute for '" + this._elementName + "' must exist.");
        }
        String id = atts.getValue("id");
        if ("selector".equals(elementName)) {
            this._fieldOrSelector = new IdentitySelector(xpath);
            if (id != null) {
                ((IdentitySelector)this._fieldOrSelector).setId(id);
            }
        } else {
            this._fieldOrSelector = new IdentityField(xpath);
            if (id != null) {
                ((IdentityField)this._fieldOrSelector).setId(id);
            }
        }
    }

    @Override
    public String elementName() {
        return this._elementName;
    }

    @Override
    public Object getObject() {
        return this._fieldOrSelector;
    }

    @Override
    public void finish() throws XMLException {
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this._depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this._foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of '" + this._elementName + "'.");
            }
            this._foundAnnotation = true;
            this._unmarshaller = new AnnotationUnmarshaller(atts);
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this._unmarshaller != null && this._depth > 0) {
            this._unmarshaller.endElement(name, namespace);
            --this._depth;
            return;
        }
        this._unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation annotation = (Annotation)this._unmarshaller.getObject();
            this._fieldOrSelector.addAnnotation(annotation);
        }
        this._unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.characters(ch, start, length);
        }
    }
}

