/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.IdentityField;
import org.exolab.castor.xml.schema.IdentitySelector;
import org.exolab.castor.xml.schema.Key;
import org.exolab.castor.xml.schema.KeyRef;
import org.exolab.castor.xml.schema.Unique;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.FieldOrSelectorUnmarshaller;

public class IdentityConstraintUnmarshaller
extends ComponentReader {
    private ComponentReader _unmarshaller;
    private int _depth = 0;
    private IdentityConstraint _identityConstraint = null;
    private boolean _foundAnnotation = false;
    private boolean _foundSelector = false;
    private boolean _foundField = false;
    private String _elementName = null;

    public IdentityConstraintUnmarshaller(String elementName, AttributeSet atts) throws XMLException {
        this._elementName = elementName;
        String name = atts.getValue("name");
        if (name == null) {
            this.error("The 'name' attribute for an identity-constraint must exist.");
        }
        String id = atts.getValue("id");
        if ("keyref".equals(elementName)) {
            String refer = atts.getValue("refer");
            if (refer == null) {
                this.error("The 'refer' attribute for keyref must exist.");
            }
            this._identityConstraint = new KeyRef(name, refer);
        } else {
            this._identityConstraint = "unique".equals(elementName) ? new Unique(name) : new Key(name);
        }
    }

    @Override
    public String elementName() {
        return this._elementName;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this._identityConstraint;
    }

    @Override
    public Object getObject() {
        return this.getIdentityConstraint();
    }

    @Override
    public void finish() throws XMLException {
        if (!this._foundSelector) {
            this.error("Invalid " + this._elementName + "; missing 'selector'.");
        } else if (!this._foundField) {
            this.error("Invalid " + this._elementName + "; missing 'field'.");
        }
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this._depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this._foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of '" + this._elementName + "'.");
            }
            if (this._foundSelector || this._foundField) {
                this.error("An annotation may only appear as the first child of '" + this._elementName + "'.");
            }
            this._foundAnnotation = true;
            this._unmarshaller = new AnnotationUnmarshaller(atts);
        } else if ("selector".equals(name)) {
            if (this._foundField) {
                String err = "The 'selector' element of '" + this._elementName + "' must appear before any 'field' elements.";
                this.error(err);
            }
            if (this._foundSelector) {
                this.error("Only one (1) 'selector' may appear as a child of '" + this._elementName + "'.");
            }
            this._foundSelector = true;
            this._unmarshaller = new FieldOrSelectorUnmarshaller(name, atts);
        } else if ("field".equals(name)) {
            this._foundField = true;
            this._unmarshaller = new FieldOrSelectorUnmarshaller(name, atts);
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this._unmarshaller != null && this._depth > 0) {
            this._unmarshaller.endElement(name, namespace);
            --this._depth;
            return;
        }
        this._unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation annotation = (Annotation)this._unmarshaller.getObject();
            this._identityConstraint.addAnnotation(annotation);
        } else if ("selector".equals(name)) {
            IdentitySelector selector = (IdentitySelector)this._unmarshaller.getObject();
            this._identityConstraint.setSelector(selector);
        } else if ("field".equals(name)) {
            IdentityField field = (IdentityField)this._unmarshaller.getObject();
            this._identityConstraint.addField(field);
        }
        this._unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.characters(ch, start, length);
        }
    }
}

