/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.util.AttributeSetImpl;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Sax2ComponentReader
implements DocumentHandler,
ErrorHandler {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String XML_PREFIX = "xml";
    private ComponentReader _compReader = null;
    private Namespaces _namespaces = null;

    public Sax2ComponentReader(ComponentReader compReader) {
        this._compReader = compReader;
        this._namespaces = new Namespaces();
    }

    private AttributeSet processAttributeList(AttributeList atts) throws SAXException {
        if (atts == null) {
            return new AttributeSetImpl(0);
        }
        int attCount = 0;
        boolean[] validAtts = new boolean[atts.getLength()];
        for (int i = 0; i < validAtts.length; ++i) {
            String attName = atts.getName(i);
            if (attName.equals(XMLNS)) {
                this._namespaces.addNamespace("", atts.getValue(i));
                continue;
            }
            if (attName.startsWith(XMLNS_PREFIX)) {
                String prefix = attName.substring(XMLNS_PREFIX.length());
                this._namespaces.addNamespace(prefix, atts.getValue(i));
                continue;
            }
            validAtts[i] = true;
            ++attCount;
        }
        AttributeSetImpl attSet = null;
        if (attCount > 0) {
            attSet = new AttributeSetImpl(attCount);
            for (int i = 0; i < validAtts.length; ++i) {
                String prefix;
                if (!validAtts[i]) continue;
                String namespace = null;
                String attName = atts.getName(i);
                int idx = attName.indexOf(58);
                if (idx > 0 && !(prefix = attName.substring(0, idx)).equals(XML_PREFIX)) {
                    attName = attName.substring(idx + 1);
                    namespace = this._namespaces.getNamespaceURI(prefix);
                    if (namespace == null) {
                        String error = "The namespace associated with the prefix '" + prefix + "' could not be resolved.";
                        throw new SAXException(error);
                    }
                }
                attSet.setAttribute(attName, atts.getValue(i), namespace);
            }
        } else {
            attSet = new AttributeSetImpl(0);
        }
        return attSet;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this._compReader.characters(ch, start, length);
        }
        catch (XMLException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String name) throws SAXException {
        String namespace = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String prefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            namespace = this._namespaces.getNamespaceURI(prefix);
        } else {
            namespace = this._namespaces.getNamespaceURI("");
        }
        if (this._namespaces.getParent() != null) {
            this._namespaces = this._namespaces.getParent();
        }
        try {
            this._compReader.endElement(name, namespace);
        }
        catch (XMLException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._compReader.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
        Namespaces nsDecls;
        this._namespaces = nsDecls = this._namespaces.createNamespaces();
        AttributeSet attSet = this.processAttributeList(atts);
        String namespace = null;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String prefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            namespace = this._namespaces.getNamespaceURI(prefix);
        } else {
            namespace = this._namespaces.getNamespaceURI("");
        }
        try {
            this._compReader.startElement(name, namespace, attSet, nsDecls);
        }
        catch (XMLException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        String systemId = exception.getSystemId();
        String err = "Parsing Error : " + exception.getMessage() + '\n' + "Line : " + exception.getLineNumber() + '\n' + "Column : " + exception.getColumnNumber() + '\n';
        if (systemId != null) {
            err = "In document: '" + systemId + "'\n" + err;
        }
        throw new SAXException(err);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        String systemId = exception.getSystemId();
        String err = "Parsing Error : " + exception.getMessage() + '\n' + "Line : " + exception.getLineNumber() + '\n' + "Column : " + exception.getColumnNumber() + '\n';
        if (systemId != null) {
            err = "In document: '" + systemId + "'\n" + err;
        }
        throw new SAXException(err);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        String systemId = exception.getSystemId();
        String err = "Parsing Error : " + exception.getMessage() + '\n' + "Line : " + exception.getLineNumber() + '\n' + "Column : " + exception.getColumnNumber() + '\n';
        if (systemId != null) {
            err = "In document: '" + systemId + "'\n" + err;
        }
        throw new SAXException(err);
    }
}

