/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.StringTokenizer;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Union;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;

public class UnionUnmarshaller
extends ComponentReader {
    private ComponentReader _unmarshaller;
    private int _depth = 0;
    private Union _union = null;
    private Schema _schema = null;
    private boolean _foundAnnotation = false;
    private boolean _foundSimpleType = false;

    public UnionUnmarshaller(Schema schema, AttributeSet atts) throws XMLException {
        if (schema == null) {
            String err = "'schema' must not be null.";
            throw new IllegalStateException(err);
        }
        this._schema = schema;
        this._union = new Union(this._schema);
        this._union.setId(atts.getValue("id"));
        String memberTypes = atts.getValue("memberTypes");
        this.processMemberTypes(memberTypes);
    }

    @Override
    public String elementName() {
        return "union";
    }

    @Override
    public Object getObject() {
        return this._union;
    }

    @Override
    public void finish() throws XMLException {
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this._depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this._foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of '" + this.elementName() + "'.");
            }
            if (this._foundSimpleType) {
                this.error("An annotation may only appear as the first child of '" + this.elementName() + "'.");
            }
            this._foundAnnotation = true;
            this._unmarshaller = new AnnotationUnmarshaller(atts);
        } else if ("simpleType".equals(name)) {
            this._foundSimpleType = true;
            this._unmarshaller = new SimpleTypeUnmarshaller(this._schema, atts);
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this._unmarshaller != null && this._depth > 0) {
            this._unmarshaller.endElement(name, namespace);
            --this._depth;
            return;
        }
        this._unmarshaller.finish();
        if ("annotation".equals(name)) {
            this._union.setLocalAnnotation((Annotation)this._unmarshaller.getObject());
        } else if ("simpleType".equals(name)) {
            SimpleType simpleType = (SimpleType)this._unmarshaller.getObject();
            if (simpleType instanceof Union) {
                String err = "A 'union' may only contain SimpleTypes of the atomic or list variety.";
                this.error(err);
            }
            this._union.addMemberType(simpleType);
        }
        this._unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this._unmarshaller != null) {
            this._unmarshaller.characters(ch, start, length);
        }
    }

    private void processMemberTypes(String memberTypes) {
        if (memberTypes == null || memberTypes.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(memberTypes);
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            SimpleType simpleType = this._schema.getSimpleType(typeName);
            if (simpleType != null) {
                this._union.addMemberType(simpleType);
                continue;
            }
            this._union.addMemberType(typeName);
        }
    }
}

