/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.util;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.util.DatatypeHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLInstance2SchemaHandler
implements DocumentHandler,
ErrorHandler {
    private static final String XMLNS = "xmlns";
    private static final String DEFAULT_PREFIX = "xsd";
    private Locator _locator = null;
    private Schema _schema = null;
    private Stack _siStack = null;
    private String _nsPrefix = null;
    private Order _defaultGroupOrder = Order.seq;

    public XMLInstance2SchemaHandler() {
        this(null);
    }

    public XMLInstance2SchemaHandler(Schema schema) {
        this._siStack = new Stack();
        this._schema = schema;
        if (this._schema == null) {
            this._schema = new Schema();
            this._schema.addNamespace(DEFAULT_PREFIX, "http://www.w3.org/2001/XMLSchema");
            this._nsPrefix = DEFAULT_PREFIX;
        } else {
            this._nsPrefix = null;
            Namespaces namespaces = this._schema.getNamespaces();
            Enumeration enumeration = namespaces.getLocalNamespacePrefixes();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (!namespaces.getNamespaceURI(key).equals("http://www.w3.org/2001/XMLSchema")) continue;
                this._nsPrefix = key;
                break;
            }
            if (this._nsPrefix == null) {
                this._schema.addNamespace(DEFAULT_PREFIX, "http://www.w3.org/2001/XMLSchema");
                this._nsPrefix = DEFAULT_PREFIX;
            }
        }
    }

    public Schema getSchema() {
        return this._schema;
    }

    protected void setDefaultGroupOrder(Order order) {
        this._defaultGroupOrder = order;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._siStack.isEmpty()) {
            return;
        }
        StateInfo sInfo = (StateInfo)this._siStack.peek();
        if (sInfo.buffer == null) {
            sInfo.buffer = new StringBuffer();
        }
        sInfo.buffer.append(ch, start, length);
        if (sInfo.complex) {
            sInfo.mixed = true;
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String name) throws SAXException {
        Group group;
        int idx = name.indexOf(58);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        StateInfo sInfo = (StateInfo)this._siStack.pop();
        if (sInfo.element.getType() == null && sInfo.buffer != null) {
            String typeName = this._nsPrefix + ':' + DatatypeHandler.guessType(sInfo.buffer.toString());
            sInfo.element.setTypeReference(typeName);
            if (sInfo.attributes.size() > 0) {
                ComplexType cType = new ComplexType(this._schema);
                cType.setContentType(ContentType.mixed);
                sInfo.element.setType(cType);
                group = new Group();
                group.setOrder(this._defaultGroupOrder);
                try {
                    cType.addGroup(group);
                    for (int i = 0; i < sInfo.attributes.size(); ++i) {
                        AttributeDecl attDecl = (AttributeDecl)sInfo.attributes.elementAt(i);
                        cType.addAttributeDecl(attDecl);
                    }
                }
                catch (SchemaException sx) {
                    throw new SAXException(sx);
                }
            }
        } else {
            ComplexType cType = (ComplexType)sInfo.element.getType();
            if (cType == null && sInfo.attributes.size() > 0) {
                cType = new ComplexType(this._schema);
                sInfo.element.setType(cType);
                Group group2 = new Group();
                group2.setOrder(this._defaultGroupOrder);
                try {
                    cType.addGroup(group2);
                }
                catch (SchemaException sx) {
                    throw new SAXException(sx);
                }
            }
            if (cType != null) {
                try {
                    for (int i = 0; i < sInfo.attributes.size(); ++i) {
                        AttributeDecl attDecl = (AttributeDecl)sInfo.attributes.elementAt(i);
                        cType.addAttributeDecl(attDecl);
                    }
                }
                catch (SchemaException sx) {
                    throw new SAXException(sx);
                }
            }
        }
        if (!this._siStack.isEmpty()) {
            StateInfo parentInfo = (StateInfo)this._siStack.peek();
            ComplexType type = (ComplexType)parentInfo.element.getType();
            group = null;
            if (type == null || type.getParticleCount() == 0) {
                if (type == null) {
                    parentInfo.complex = true;
                    type = new ComplexType(this._schema);
                    parentInfo.element.setType(type);
                }
                group = new Group();
                group.setOrder(this._defaultGroupOrder);
                try {
                    type.addGroup(group);
                    group.addElementDecl(sInfo.element);
                }
                catch (SchemaException sx) {
                    throw new SAXException(sx);
                }
            }
            group = (Group)type.getParticle(0);
            ElementDecl element = group.getElementDecl(name);
            boolean checkGroupType = false;
            if (element != null) {
                if (sInfo.complex) {
                    try {
                        this.merge(element, sInfo.element);
                    }
                    catch (SchemaException sx) {
                        throw new SAXException(sx);
                    }
                }
                element.setMaxOccurs(Particle.UNBOUNDED);
                checkGroupType = true;
            } else {
                try {
                    group.addElementDecl(sInfo.element);
                }
                catch (SchemaException sx) {
                    throw new SAXException(sx);
                }
            }
            if (checkGroupType && group.getOrder() == Order.seq) {
                boolean found = false;
                boolean changeType = false;
                for (int i = 0; i < group.getParticleCount(); ++i) {
                    if (found) {
                        changeType = true;
                        break;
                    }
                    if (element != group.getParticle(i)) continue;
                    found = true;
                }
                if (changeType) {
                    group.setOrder(Order.all);
                }
            }
        } else {
            try {
                this._schema.addElementDecl(sInfo.element);
            }
            catch (SchemaException sx) {
                throw new SAXException(sx);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
        int idx = name.indexOf(58);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        StateInfo sInfo = null;
        boolean topLevel = false;
        if (!this._siStack.isEmpty()) {
            sInfo = (StateInfo)this._siStack.peek();
            sInfo.complex = true;
        } else {
            topLevel = true;
        }
        sInfo = new StateInfo();
        sInfo.topLevel = topLevel;
        this._siStack.push(sInfo);
        sInfo.element = new ElementDecl(this._schema, name);
        for (int i = 0; i < atts.getLength(); ++i) {
            String attName = atts.getName(i);
            if (attName.equals(XMLNS)) continue;
            String prefix = "";
            idx = attName.indexOf(58);
            if (idx >= 0) {
                prefix = attName.substring(0, idx);
                attName = attName.substring(idx + 1);
            }
            if (prefix.equals(XMLNS)) continue;
            AttributeDecl attr = new AttributeDecl(this._schema, attName);
            String typeName = this._nsPrefix + ':' + DatatypeHandler.guessType(atts.getValue(i));
            attr.setSimpleTypeReference(typeName);
            sInfo.attributes.addElement(attr);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    private static boolean isWhiteSpace(char[] chars, int start, int length) {
        int max = start + length;
        block3: for (int i = start; i < max; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void merge(ElementDecl e1, ElementDecl e2) throws SchemaException {
        ElementDecl element;
        Particle particle;
        Group e2Group;
        Group group;
        ComplexType cType;
        XMLType e1Type = e1.getType();
        XMLType e2Type = e2.getType();
        if (e1Type == null) {
            if (e2Type == null) {
                return;
            }
            if (e2Type.isSimpleType()) {
                e1.setType(e2Type);
            } else {
                cType = new ComplexType(this._schema);
                group = new Group();
                group.setOrder(this._defaultGroupOrder);
                cType.addGroup(group);
                e1.setType(cType);
                e1Type = cType;
            }
        } else if (e2Type == null) {
            if (e1Type.isSimpleType()) {
                e2.setType(e1Type);
            } else {
                cType = new ComplexType(this._schema);
                group = new Group();
                group.setOrder(this._defaultGroupOrder);
                cType.addGroup(group);
                e2.setType(cType);
                e2Type = cType;
            }
        }
        if (e1Type.isSimpleType() && e2Type.isSimpleType()) {
            if (!e1Type.getName().equals(e2Type.getName())) {
                String typeName = this._nsPrefix + ':' + DatatypeHandler.whichType(e1Type.getName(), e2Type.getName());
                e1.setType(null);
                e1.setTypeReference(typeName);
            }
            return;
        }
        if (e1Type.isSimpleType()) {
            cType = new ComplexType(this._schema);
            e1.setType(cType);
            group = new Group();
            group.setOrder(this._defaultGroupOrder);
            cType.addGroup(group);
            cType.setContentType(ContentType.mixed);
            e1Type = cType;
        } else if (e2Type.isSimpleType()) {
            cType = new ComplexType(this._schema);
            e2.setType(cType);
            group = new Group();
            group.setOrder(this._defaultGroupOrder);
            cType.addGroup(group);
            cType.setContentType(ContentType.mixed);
            e2Type = cType;
        }
        ComplexType cType1 = (ComplexType)e1Type;
        ComplexType cType2 = (ComplexType)e2Type;
        Group e1Group = (Group)cType1.getParticle(0);
        if (e1Group == null) {
            e1Group = new Group();
            e1Group.setOrder(this._defaultGroupOrder);
            cType1.addGroup(e1Group);
        }
        if ((e2Group = (Group)cType2.getParticle(0)) == null) {
            e2Group = new Group();
            e2Group.setOrder(this._defaultGroupOrder);
            cType2.addGroup(e2Group);
        }
        Enumeration enumeration = e2Group.enumerate();
        while (enumeration.hasMoreElements()) {
            particle = (Particle)enumeration.nextElement();
            if (particle.getStructureType() != 8) continue;
            element = (ElementDecl)particle;
            ElementDecl main = e1Group.getElementDecl(element.getName());
            if (main == null) {
                e1Group.addElementDecl(element);
                element.setMinOccurs(0);
                continue;
            }
            this.merge(main, element);
        }
        enumeration = cType2.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            String type2;
            AttributeDecl attNew = (AttributeDecl)enumeration.nextElement();
            String attName = attNew.getName();
            AttributeDecl attPrev = cType1.getAttributeDecl(attName);
            if (attPrev == null) {
                attNew.setUse("optional");
                cType1.addAttributeDecl(attNew);
                continue;
            }
            String type1 = attPrev.getSimpleType().getName();
            if (type1.equals(type2 = attNew.getSimpleType().getName())) continue;
            String typeName = this._nsPrefix + ':' + DatatypeHandler.whichType(type1, type2);
            attPrev.setSimpleTypeReference(typeName);
        }
        enumeration = e1Group.enumerate();
        while (enumeration.hasMoreElements()) {
            particle = (Particle)enumeration.nextElement();
            if (particle.getStructureType() != 8 || e2Group.getElementDecl((element = (ElementDecl)particle).getName()) != null) continue;
            element.setMinOccurs(0);
        }
    }

    class StateInfo {
        Namespaces namespaces = null;
        ElementDecl element = null;
        Vector attributes = new Vector();
        StringBuffer buffer = null;
        boolean mixed = false;
        boolean complex = false;
        boolean topLevel = false;
    }
}

