/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.xml.ClassDescriptorEnumeration;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;

public class ClassDescriptorResolverImpl
implements ClassDescriptorResolver {
    private static final String DESCRIPTOR_PREFIX = "Descriptor";
    private static final String INTERNAL_CONTAINER_NAME = "-error-if-this-is-used-";
    private Hashtable _cacheViaClass = new Hashtable();
    private Hashtable _cacheViaName = new Hashtable();
    private Hashtable _classNotFoundList = null;
    private boolean _error = false;
    private String _errMessage = null;
    private Introspector _introspector = null;
    private ClassLoader _loader = null;
    private XMLMappingLoader _mappingLoader = null;
    private boolean _useIntrospection = true;

    public ClassDescriptorResolverImpl() {
    }

    public ClassDescriptorResolverImpl(ClassLoader loader) {
        this();
        this._loader = loader;
    }

    public void associate(Class type, XMLClassDescriptor classDesc) {
        if (type == null) {
            throw new IllegalArgumentException("argument 'type' must not be null.");
        }
        if (classDesc == null) {
            if (type != null) {
                this._cacheViaClass.remove(type);
            }
        } else {
            this._cacheViaClass.put(type, classDesc);
            String xmlName = classDesc.getXMLName();
            if (xmlName != null && xmlName.length() > 0 && !INTERNAL_CONTAINER_NAME.equals(xmlName)) {
                String nameKey = xmlName;
                String ns = classDesc.getNameSpaceURI();
                if (ns != null && ns.length() > 0) {
                    nameKey = ns + ':' + xmlName;
                }
                this._cacheViaName.put(nameKey, classDesc);
            }
        }
    }

    @Override
    public String getErrorMessage() {
        return this._errMessage;
    }

    public Introspector getIntrospector() {
        if (this._introspector == null) {
            this._introspector = new Introspector();
        }
        return this._introspector;
    }

    @Override
    public XMLMappingLoader getMappingLoader() {
        return this._mappingLoader;
    }

    @Override
    public boolean error() {
        return this._error;
    }

    @Override
    public XMLClassDescriptor resolve(Class type) {
        this.clearError();
        if (type == null) {
            return null;
        }
        XMLClassDescriptor classDesc = (XMLClassDescriptor)this._cacheViaClass.get(type);
        if (classDesc != null) {
            return classDesc;
        }
        if (this._mappingLoader != null && (classDesc = (XMLClassDescriptor)this._mappingLoader.getDescriptor(type)) != null) {
            this._cacheViaClass.put(type, classDesc);
            return classDesc;
        }
        String className = type.getName() + DESCRIPTOR_PREFIX;
        try {
            ClassLoader loader = type.getClassLoader();
            Class dClass = this.loadClass(className, loader);
            classDesc = (XMLClassDescriptor)dClass.newInstance();
            this._cacheViaClass.put(type, classDesc);
        }
        catch (ClassNotFoundException loader) {
        }
        catch (Exception ex) {
            String err = "instantiation error for class: " + className;
            err = err + "; " + ex.toString();
            this.setError(err);
            return null;
        }
        if (classDesc == null && this._useIntrospection) {
            try {
                classDesc = this.getIntrospector().generateClassDescriptor(type);
                if (classDesc != null) {
                    this._cacheViaClass.put(type, classDesc);
                }
            }
            catch (MarshalException mx) {
                String err = mx.toString();
                this.setError(err);
                return null;
            }
        }
        return classDesc;
    }

    @Override
    public XMLClassDescriptor resolve(String className) {
        return this.resolve(className, null);
    }

    @Override
    public XMLClassDescriptor resolve(String className, ClassLoader loader) {
        XMLClassDescriptor classDesc = null;
        if (className == null || className.length() == 0) {
            this.clearError();
            this.setError("Cannot resolve a null or zero-length class name.");
            return null;
        }
        if (this._mappingLoader != null && (classDesc = (XMLClassDescriptor)this._mappingLoader.getDescriptor(className)) != null) {
            return classDesc;
        }
        Class _class = null;
        try {
            _class = this.loadClass(className, loader);
        }
        catch (ClassNotFoundException cnfe) {
            if (this._classNotFoundList == null) {
                this._classNotFoundList = new Hashtable();
            }
            this._classNotFoundList.put(className, cnfe);
        }
        if (_class != null) {
            classDesc = this.resolve(_class);
        } else {
            this.clearError();
        }
        if (classDesc == null && _class == null) {
            String dClassName = className + DESCRIPTOR_PREFIX;
            try {
                Class dClass = this.loadClass(dClassName, loader);
                classDesc = (XMLClassDescriptor)dClass.newInstance();
                if (classDesc.getJavaClass() != null) {
                    this.associate(classDesc.getJavaClass(), classDesc);
                }
            }
            catch (InstantiationException dClass) {
            }
            catch (IllegalAccessException dClass) {
            }
            catch (ClassNotFoundException cnfe) {
                if (this._classNotFoundList == null) {
                    this._classNotFoundList = new Hashtable();
                }
                this._classNotFoundList.put(className, cnfe);
            }
        }
        return classDesc;
    }

    @Override
    public XMLClassDescriptor resolveByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            this.clearError();
            this.setError("Cannot resolve a null or zero-length xml name.");
            return null;
        }
        XMLClassDescriptor classDesc = null;
        Enumeration enumeration = null;
        String nameKey = xmlName;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            nameKey = namespaceURI + ':' + xmlName;
        }
        if ((classDesc = (XMLClassDescriptor)this._cacheViaName.get(nameKey)) != null) {
            return classDesc;
        }
        XMLClassDescriptor possibleMatch = null;
        if (this._mappingLoader != null) {
            enumeration = this._mappingLoader.listDescriptors();
            while (enumeration.hasMoreElements()) {
                classDesc = (XMLClassDescriptor)enumeration.nextElement();
                if (xmlName.equals(classDesc.getXMLName())) {
                    if (this.namespaceEquals(namespaceURI, classDesc.getNameSpaceURI())) {
                        this._cacheViaName.put(nameKey, classDesc);
                        return classDesc;
                    }
                    possibleMatch = classDesc;
                }
                classDesc = null;
            }
        }
        enumeration = this._cacheViaClass.elements();
        while (enumeration.hasMoreElements()) {
            classDesc = (XMLClassDescriptor)enumeration.nextElement();
            if (xmlName.equals(classDesc.getXMLName())) {
                if (this.namespaceEquals(namespaceURI, classDesc.getNameSpaceURI())) {
                    this._cacheViaName.put(nameKey, classDesc);
                    return classDesc;
                }
                if (possibleMatch == null) {
                    possibleMatch = classDesc;
                } else if (possibleMatch != classDesc) {
                    possibleMatch = null;
                }
            }
            classDesc = null;
        }
        if (classDesc == null) {
            classDesc = possibleMatch;
        }
        return classDesc;
    }

    @Override
    public ClassDescriptorEnumeration resolveAllByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            this.clearError();
            this.setError("Cannot resolve a null or zero-length xml name.");
            return null;
        }
        XCDEnumerator xcdEnumerator = new XCDEnumerator();
        XMLClassDescriptor classDesc = null;
        Enumeration enumeration = null;
        if (this._mappingLoader != null) {
            enumeration = this._mappingLoader.listDescriptors();
            while (enumeration.hasMoreElements()) {
                classDesc = (XMLClassDescriptor)enumeration.nextElement();
                if (!xmlName.equals(classDesc.getXMLName())) continue;
                xcdEnumerator.add(classDesc);
            }
        }
        enumeration = this._cacheViaClass.elements();
        while (enumeration.hasMoreElements()) {
            classDesc = (XMLClassDescriptor)enumeration.nextElement();
            if (!xmlName.equals(classDesc.getXMLName())) continue;
            xcdEnumerator.add(classDesc);
        }
        return xcdEnumerator;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setIntrospection(boolean enable) {
        this._useIntrospection = enable;
    }

    @Override
    public void setMappingLoader(XMLMappingLoader mappingLoader) {
        this._mappingLoader = mappingLoader;
    }

    private Class loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        Object exception;
        if (this._classNotFoundList != null && (exception = this._classNotFoundList.get(className)) != null) {
            throw (ClassNotFoundException)exception;
        }
        try {
            if (loader != null) {
                return loader.loadClass(className);
            }
            if (this._loader != null) {
                return this._loader.loadClass(className);
            }
            return Class.forName(className);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new ClassNotFoundException(ncdfe.getMessage());
        }
    }

    private void clearError() {
        this._error = false;
    }

    private void setError(String message) {
        this._error = true;
        this._errMessage = message;
    }

    private boolean namespaceEquals(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null || ns2.length() == 0;
        }
        if (ns2 == null) {
            return ns1.length() == 0;
        }
        return ns1.equals(ns2);
    }

    class XCDEnumerator
    implements ClassDescriptorEnumeration {
        private Entry _current = null;
        private Entry _last = null;

        XCDEnumerator() {
        }

        protected void add(XMLClassDescriptor classDesc) {
            Entry entry = new Entry();
            entry.classDesc = classDesc;
            if (this._current == null) {
                this._current = entry;
                this._last = entry;
            } else {
                this._last.next = entry;
                this._last = entry;
            }
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public XMLClassDescriptor getNext() {
            if (this._current == null) {
                return null;
            }
            Entry entry = this._current;
            this._current = this._current.next;
            return entry.classDesc;
        }

        class Entry {
            XMLClassDescriptor classDesc = null;
            Entry next = null;

            Entry() {
            }
        }
    }
}

