/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;

public class BooleanValidator
implements TypeValidator {
    private boolean _useFixed = false;
    private boolean _fixed = false;

    public void clearFixed() {
        this._useFixed = false;
    }

    public Boolean getFixed() {
        if (this._useFixed) {
            return new Boolean(this._fixed);
        }
        return null;
    }

    public boolean hasFixed() {
        return this._useFixed;
    }

    public void setFixed(boolean fixedValue) {
        this._useFixed = true;
        this._fixed = fixedValue;
    }

    public void setFixed(Boolean fixedValue) {
        this._useFixed = true;
        this._fixed = fixedValue;
    }

    public void validate(boolean b) throws ValidationException {
        if (this._useFixed) {
            if (b != this._fixed) {
                String err = b + " is not equal to the fixed value of " + this._fixed;
                throw new ValidationException(err);
            }
            return;
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "BooleanValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        boolean value = false;
        try {
            value = (Boolean)object;
        }
        catch (Exception ex) {
            String err = "Expecting a Boolean, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value);
    }
}

