/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class DoubleValidator
extends PatternValidator
implements TypeValidator {
    private boolean _isFixed = false;
    private double _fixed = 0.0;
    private boolean _isThereMinInclusive = false;
    private double _minInclusive = 0.0;
    private boolean _isThereMaxInclusive = false;
    private double _maxInclusive = 0.0;
    private boolean _isThereMinExclusive = false;
    private double _minExclusive = 0.0;
    private boolean _isThereMaxExclusive = false;
    private double _maxExclusive = 0.0;

    public void setFixed(double fixed) {
        this._fixed = fixed;
        this._isFixed = true;
    }

    public void setMinExclusive(double minValue) {
        this._minExclusive = minValue;
        this._isThereMinExclusive = true;
    }

    public void setMinInclusive(double minValue) {
        this._minInclusive = minValue;
        this._isThereMinInclusive = true;
    }

    public void setMaxExclusive(double maxValue) {
        this._maxExclusive = maxValue;
        this._isThereMaxExclusive = true;
    }

    public void setMaxInclusive(double maxValue) {
        this._maxInclusive = maxValue;
        this._isThereMaxInclusive = true;
    }

    public void validate(double d, ValidationContext context) throws ValidationException {
        if (this._isFixed && d != this._fixed) {
            String err = d + " is not equal to the fixed value of ";
            err = err + this._fixed;
            throw new ValidationException(err);
        }
        if (this._isThereMinInclusive && d < this._minInclusive) {
            String err = d + " is less than the minimum allowable ";
            err = err + "value of " + this._minInclusive;
            throw new ValidationException(err);
        }
        if (this._isThereMinExclusive && d <= this._minExclusive) {
            String err = d + " is less than the minimum allowable ";
            err = err + "value of " + this._minExclusive;
            throw new ValidationException(err);
        }
        if (this._isThereMaxInclusive && d > this._maxInclusive) {
            String err = d + " is greater than the maximum allowable ";
            err = err + "value of " + this._maxInclusive;
            throw new ValidationException(err);
        }
        if (this._isThereMaxExclusive && d >= this._maxExclusive) {
            String err = d + " is greater than the maximum allowable ";
            err = err + "value of " + this._maxExclusive;
            throw new ValidationException(err);
        }
        if (this.hasPattern()) {
            super.validate(Double.toString(d), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "doubleValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        double value = 0.0;
        try {
            value = new Double(object.toString());
        }
        catch (Exception ex) {
            String err = "Expecting a double, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value, context);
    }
}

