/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.types.Duration;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;

public class DurationValidator
implements TypeValidator {
    private Duration _maxInclusive;
    private Duration _maxExclusive;
    private Duration _minInclusive;
    private Duration _minExclusive;

    public void setMaxExclusive(Duration max) {
        this._maxExclusive = max;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(Duration max) {
        this._maxInclusive = max;
        this._maxExclusive = null;
    }

    public void setMinExclusive(Duration min) {
        this._minExclusive = min;
        this._minInclusive = null;
    }

    public void setMinInclusive(Duration min) {
        this._minInclusive = min;
        this._minExclusive = null;
    }

    public void validate(Duration duration) throws ValidationException {
        boolean isThereMaxExclusive;
        boolean isThereMinInclusive = this._minInclusive != null;
        boolean isThereMinExclusive = this._minExclusive != null;
        boolean isThereMaxInclusive = this._maxInclusive != null;
        boolean bl = isThereMaxExclusive = this._maxExclusive != null;
        if (isThereMinExclusive && isThereMinInclusive) {
            throw new ValidationException("both minInclusive and minExclusiveare set up");
        }
        if (isThereMaxExclusive && isThereMaxInclusive) {
            throw new ValidationException("both maxInclusive and maxExclusiveare set up");
        }
        if (isThereMinInclusive && this._minInclusive.isGreater(duration)) {
            String err = duration + " is less than the minimum allowable ";
            err = err + "value of " + this._minInclusive;
            throw new ValidationException(err);
        }
        if (isThereMinExclusive && (this._minExclusive.isGreater(duration) || duration.equals(this._minExclusive))) {
            String err = duration + " is less than the minimum allowable ";
            err = err + "value of " + this._minExclusive;
            throw new ValidationException(err);
        }
        if (isThereMaxInclusive && duration.isGreater(this._maxInclusive)) {
            String err = duration + " is greater than the maximum allowable ";
            err = err + "value of " + this._maxInclusive;
            throw new ValidationException(err);
        }
        if (isThereMaxExclusive && (duration.isGreater(this._maxExclusive) || duration.equals(this._maxExclusive))) {
            String err = duration + " is greater than the maximum allowable ";
            err = err + "value of " + this._maxExclusive;
            throw new ValidationException(err);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "durationValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        Duration value = null;
        try {
            value = Duration.parseDuration(object.toString());
        }
        catch (Exception ex) {
            String err = "Expecting a duration, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value);
    }
}

