/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class IntegerValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private int min = 0;
    private int max = 0;
    private int _totalDigits = -1;
    private int fixed = 0;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public Integer getFixed() {
        if (this.useFixed) {
            return new Integer(this.fixed);
        }
        return null;
    }

    public Integer getMaxInclusive() {
        if (this.useMax) {
            return new Integer(this.max);
        }
        return null;
    }

    public Integer getMinInclusive() {
        if (this.useMin) {
            return new Integer(this.min);
        }
        return null;
    }

    public Integer getTotalDigits() {
        if (this._totalDigits >= 0) {
            return new Integer(this._totalDigits);
        }
        return null;
    }

    public boolean hasFixed() {
        return this.useFixed;
    }

    public void setFixed(int fixedValue) {
        this.useFixed = true;
        this.fixed = fixedValue;
    }

    public void setFixed(Integer fixedValue) {
        this.useFixed = true;
        this.fixed = fixedValue;
    }

    public void setMinExclusive(int minValue) {
        this.useMin = true;
        this.min = minValue + 1;
    }

    public void setMinInclusive(int minValue) {
        this.useMin = true;
        this.min = minValue;
    }

    public void setMaxExclusive(int maxValue) {
        this.useMax = true;
        this.max = maxValue - 1;
    }

    public void setMaxInclusive(int maxValue) {
        this.useMax = true;
        this.max = maxValue;
    }

    public void setTotalDigits(int totalDig) {
        if (totalDig <= 0) {
            throw new IllegalArgumentException("IntegerValidator: the totalDigits facet must be positive");
        }
        this._totalDigits = totalDig;
    }

    public void validate(int i, ValidationContext context) throws ValidationException {
        int length;
        if (this.useFixed) {
            if (i != this.fixed) {
                String err = i + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(err);
            }
            return;
        }
        if (this.useMin && i < this.min) {
            String err = i + " is less than the minimum allowable ";
            err = err + "value of " + this.min;
            throw new ValidationException(err);
        }
        if (this.useMax && i > this.max) {
            String err = i + " is greater than the maximum allowable ";
            err = err + "value of " + this.max;
            throw new ValidationException(err);
        }
        if (this._totalDigits != -1 && (length = new Integer(i).toString().length()) > this._totalDigits) {
            String err = i + " doesn't have the correct number of digits, it must be less than or equal to " + this._totalDigits;
            throw new ValidationException(err);
        }
        if (this.hasPattern()) {
            super.validate(Integer.toString(i), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "IntegerValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        int value = 0;
        try {
            value = (Integer)object;
        }
        catch (Exception ex) {
            String err = "Expecting an Integer, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value, context);
    }
}

