/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class ShortValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private short min = 0;
    private short max = 0;
    private short fixed = 0;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public Short getFixed() {
        if (this.useFixed) {
            return new Short(this.fixed);
        }
        return null;
    }

    public Short getMaxInclusive() {
        if (this.useMax) {
            return new Short(this.max);
        }
        return null;
    }

    public Short getMinInclusive() {
        if (this.useMin) {
            return new Short(this.min);
        }
        return null;
    }

    public boolean hasFixed() {
        return this.useFixed;
    }

    public void setFixed(short fixedValue) {
        this.useFixed = true;
        this.fixed = fixedValue;
    }

    public void setMinExclusive(short minValue) {
        this.useMin = true;
        this.min = (short)(minValue + 1);
    }

    public void setMinInclusive(short minValue) {
        this.useMin = true;
        this.min = minValue;
    }

    public void setMaxExclusive(short maxValue) {
        this.useMax = true;
        this.max = (short)(maxValue - 1);
    }

    public void setMaxInclusive(short maxValue) {
        this.useMax = true;
        this.max = maxValue;
    }

    public void validate(short s, ValidationContext context) throws ValidationException {
        if (this.useFixed) {
            if (s != this.fixed) {
                String err = s + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(err);
            }
            return;
        }
        if (this.useMin && s < this.min) {
            String err = s + " is less than the minimum allowable ";
            err = err + "value of " + this.min;
            throw new ValidationException(err);
        }
        if (this.useMax && s > this.max) {
            String err = s + " is greater than the maximum allowable ";
            err = err + "value of " + this.max;
            throw new ValidationException(err);
        }
        if (this.hasPattern()) {
            super.validate(Short.toString(s), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    @Override
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "ShortValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        short value = 0;
        try {
            value = (Short)object;
        }
        catch (Exception ex) {
            String err = "Expecting a Short, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value, context);
    }
}

