/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JType;

public class JField
extends JAnnotatedElementHelper
implements JMember {
    private JModifiers modifiers = null;
    private JType type = null;
    private String name = null;
    private JDocComment comment = null;
    private String initString = null;
    private JClass declaringClass = null;

    public JField(JType type, String name) {
        this.setName(name);
        this.type = type;
        this.modifiers = new JModifiers();
        this.modifiers.makePrivate();
        this.comment = new JDocComment();
        this.comment.appendComment("Field " + name);
    }

    public JDocComment getComment() {
        return this.comment;
    }

    public JClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String getInitString() {
        return this.initString;
    }

    @Override
    public JModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JType getType() {
        return this.type;
    }

    public void setComment(JDocComment comment) {
        this.comment = comment;
    }

    public void setComment(String comment) {
        if (this.comment == null) {
            this.comment = new JDocComment();
        }
        this.comment.setComment(comment);
    }

    public void setInitString(String init) {
        this.initString = init;
    }

    public void setName(String name) throws IllegalArgumentException {
        if (!JNaming.isValidJavaIdentifier(name)) {
            String err = "'" + name + "' is ";
            err = JNaming.isKeyword(name) ? err + "a reserved word and may not be used as  a field name." : err + "not a valid Java identifier.";
            throw new IllegalArgumentException(err);
        }
        this.name = name;
    }

    public void setModifiers(JModifiers modifiers) {
        this.modifiers = modifiers;
    }

    protected void setDeclaringClass(JClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.modifiers.toString());
        sb.append(' ');
        sb.append(this.type);
        sb.append(' ');
        sb.append(this.name);
        return sb.toString();
    }
}

