/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JMethod
implements JMember,
JAnnotatedElement {
    private Vector _classes = null;
    private JDocComment jdc = null;
    private JSourceCode source = null;
    private JMethodSignature _signature = null;

    public JMethod(String name) {
        this(null, name);
    }

    public JMethod(JType returnType, String name) {
        if (name == null || name.length() == 0) {
            String err = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this._classes = new Vector(1);
        this.source = new JSourceCode();
        this._signature = new JMethodSignature(name, returnType);
        this.jdc = this._signature.getJDocComment();
        this.jdc.appendComment("Method " + name + "\n\n");
    }

    public void addException(JClass exp) {
        this._signature.addException(exp);
    }

    public void addParameter(JParameter parameter) throws IllegalArgumentException {
        this._signature.addParameter(parameter);
        JType jType = parameter.getType();
        while (jType.isArray()) {
            jType = jType.getComponentType();
        }
        if (!jType.isPrimitive()) {
            JClass jClass = (JClass)jType;
            for (int i = 0; i < this._classes.size(); ++i) {
                ((JClass)this._classes.elementAt(i)).addImport(jClass.getName());
            }
        }
    }

    public JDocComment getJDocComment() {
        return this.jdc;
    }

    public JClass[] getExceptions() {
        return this._signature.getExceptions();
    }

    @Override
    public JModifiers getModifiers() {
        return this._signature.getModifiers();
    }

    @Override
    public String getName() {
        return this._signature.getName();
    }

    public JParameter getParameter(int index) {
        return this._signature.getParameter(index);
    }

    public JParameter[] getParameters() {
        return this._signature.getParameters();
    }

    public JType getReturnType() {
        return this._signature.getReturnType();
    }

    public JMethodSignature getSignature() {
        return this._signature;
    }

    public JSourceCode getSourceCode() {
        return this.source;
    }

    public void setName(String name) {
        this._signature.setName(name);
    }

    public void setComment(String comment) {
        this.jdc.setComment(comment);
    }

    public void setModifiers(JModifiers modifiers) {
        this._signature.setModifiers(modifiers);
    }

    public void setSourceCode(String source) {
        this.source = new JSourceCode(source);
    }

    public void setSourceCode(JSourceCode source) {
        this.source = source;
    }

    public void print(JSourceWriter jsw) {
        this.jdc.print(jsw);
        this._signature.print(jsw, false);
        if (this._signature.getModifiers().isAbstract()) {
            jsw.writeln(";");
        } else {
            jsw.writeln();
            jsw.writeln("{");
            this.source.print(jsw);
            jsw.write("} //-- ");
            jsw.writeln(this.toString());
        }
    }

    public String toString() {
        return this._signature.toString();
    }

    @Override
    public JAnnotation getAnnotation(JAnnotationType annotationType) {
        return this._signature.getAnnotation(annotationType);
    }

    @Override
    public JAnnotation[] getAnnotations() {
        return this._signature.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(JAnnotationType annotationType) {
        return this._signature.isAnnotationPresent(annotationType);
    }

    @Override
    public void addAnnotation(JAnnotation annotation) throws IllegalArgumentException {
        this._signature.addAnnotation(annotation);
    }

    @Override
    public JAnnotation removeAnnotation(JAnnotationType annotationType) throws IllegalArgumentException {
        return this._signature.removeAnnotation(annotationType);
    }

    @Override
    public boolean hasAnnotations() {
        return this._signature.hasAnnotations();
    }

    protected void addDeclaringClass(JClass jClass) {
        this._classes.addElement(jClass);
    }

    protected void removeDeclaringClass(JClass jClass) {
        this._classes.removeElement(jClass);
    }

    protected String[] getParameterClassNames() {
        return this._signature.getParameterClassNames();
    }
}

