/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.calc;

import alma.common.sensitivitycalculatorcore.enumerations.BasicAntenna;
import alma.common.sensitivitycalculatorcore.exceptions.InvalidCoordException;
import alma.common.sensitivitycalculatorcore.exceptions.InvalidFrequencyException;
import alma.common.sensitivitycalculatorcore.exceptions.OutOfRangeException;
import alma.common.sensitivitycalculatorcore.exceptions.SourceNeverVisibleException;
import alma.common.sensitivitycalculatorcore.lookup.AtmosphereTable;
import alma.common.sensitivitycalculatorcore.lookup.BasicReceiverBand;
import alma.common.sensitivitycalculatorcore.lookup.ReceiverTemperature;
import alma.common.sensitivitycalculatorcore.utils.Convert;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExposureTimeCalculator {
    public static final boolean INTERFEROMETRY = true;
    public static final boolean SINGLEDISH = false;
    static final double BOLTZMANN = 1380.0000000000002;
    static final double PLANCK = 6.626E-34;
    static final double LIGHTSPEED = 2.99792458E8;
    public static final double ZENITH_LIMIT = 90.0;
    public static final double SENSITIVITY_EFFICIENCY_FACTOR = 1.11;
    public static final double TIME_FACTOR = 1.2321000000000002;
    private static Logger logger = Logger.getLogger("OT");

    public static double pointSourceExposureTime(double sensitivityJy, double frequencyGHz, double bandwidthGHz, double corrEfficiency, double decDeg, int numberAntennas, double antennaDiameter, double latitudeDeg, int wvindex, boolean interferometry) throws InvalidFrequencyException, SourceNeverVisibleException {
        double sec;
        double tmp;
        double rho_e = ExposureTimeCalculator.antennaEfficiency(antennaDiameter, frequencyGHz);
        double tsys = ExposureTimeCalculator.getTsys(decDeg, latitudeDeg, frequencyGHz, wvindex);
        double bandwidthHz = bandwidthGHz * 1.0E9;
        if (interferometry) {
            tmp = rho_e * tsys / (corrEfficiency * ExposureTimeCalculator.instrumentDecor() * ExposureTimeCalculator.atmosphericDecor() * sensitivityJy);
            sec = tmp * tmp / ((double)(numberAntennas * (numberAntennas - 1)) * bandwidthHz);
        } else {
            tmp = rho_e * tsys / (corrEfficiency * sensitivityJy);
            sec = tmp * tmp / ((double)numberAntennas * bandwidthHz);
        }
        StringBuilder log = new StringBuilder();
        log.append(String.format("Exposure Time  =  %.9f sec", sec));
        log.append(" * ");
        log.append(1.2321000000000002);
        log.append(String.format(" =  %.9f sec", sec *= 1.2321000000000002));
        logger.log(Level.FINEST, log.toString());
        return sec;
    }

    public static double pointSourceSensitivity(double exposureTimeSec, double frequencyGHz, double bandwidthGHz, double corrEfficiency, double decDeg, int numberAntennas, double antennaDiameter, double latitudeDeg, int wvindex, boolean interferometry) throws InvalidFrequencyException, SourceNeverVisibleException {
        double tsys = ExposureTimeCalculator.getTsys(decDeg, latitudeDeg, frequencyGHz, wvindex);
        return ExposureTimeCalculator.pointSourceSensitivity(exposureTimeSec, frequencyGHz, bandwidthGHz, corrEfficiency, decDeg, numberAntennas, antennaDiameter, latitudeDeg, wvindex, interferometry, tsys);
    }

    public static double pointSourceSensitivity(double exposureTimeSec, double frequencyGHz, double bandwidthGHz, double corrEfficiency, double decDeg, int numberAntennas, double antennaDiameter, double latitudeDeg, int wvindex, boolean interferometry, double tsys) throws InvalidFrequencyException, SourceNeverVisibleException {
        double jy;
        StringBuilder log = new StringBuilder();
        log.append("#sec=" + exposureTimeSec);
        log.append(",fGHz=" + frequencyGHz);
        log.append(",wGHz=" + bandwidthGHz);
        log.append(",corrEff=" + corrEfficiency);
        log.append(",dec=" + decDeg);
        log.append(",nAnt=" + numberAntennas);
        log.append(",diam=" + antennaDiameter);
        log.append(",obsLat=" + latitudeDeg);
        log.append(",wv=" + wvindex);
        log.append(",intrf=" + interferometry);
        double rho_e = ExposureTimeCalculator.antennaEfficiency(antennaDiameter, frequencyGHz);
        double bandwidthHz = bandwidthGHz * 1.0E9;
        if (interferometry) {
            double tmp = rho_e * tsys / (corrEfficiency * ExposureTimeCalculator.instrumentDecor() * ExposureTimeCalculator.atmosphericDecor());
            jy = tmp / Math.sqrt((double)(numberAntennas * (numberAntennas - 1)) * bandwidthHz * exposureTimeSec);
        } else {
            jy = rho_e * tsys / corrEfficiency / Math.sqrt((double)numberAntennas * bandwidthHz * exposureTimeSec);
        }
        logger.log(Level.FINEST, "Result before efficiency adjustment =" + jy);
        logger.log(Level.FINEST, "Efficiency factor (nu_r)            =1.11");
        logger.log(Level.FINEST, "Result after efficiency adjustment =" + (jy *= 1.11));
        return jy;
    }

    public static double extendedSourceExposureTime(double brightnessTemp, double resolution, double frequencyGHz, double bandwidthGHz, double corrEfficiency, double decDeg, int numberAntennas, double antennaDiameter, double latitudeDeg, int wvindex, boolean interferometry) throws SourceNeverVisibleException, InvalidFrequencyException {
        double sensitivity;
        if (interferometry) {
            sensitivity = ExposureTimeCalculator.toFluxDensity(brightnessTemp, frequencyGHz, resolution);
        } else {
            BasicAntenna ant = antennaDiameter == 7.0 ? BasicAntenna.ANTENNA_7M : BasicAntenna.ANTENNA_12M;
            double beamsize = ant.getBeamSize(frequencyGHz);
            sensitivity = ExposureTimeCalculator.toFluxDensity(brightnessTemp, frequencyGHz, beamsize);
        }
        double expTime = ExposureTimeCalculator.pointSourceExposureTime(sensitivity, frequencyGHz, bandwidthGHz, corrEfficiency, decDeg, numberAntennas, antennaDiameter, latitudeDeg, wvindex, interferometry);
        return expTime;
    }

    public static double extendedSourceBrightnessTemp(double exposureTimeSec, double resolution, double frequencyGHz, double bandwidthGHz, double corrEfficiency, double decDeg, int numberAntennas, double antennaDiameter, double latitudeDeg, int wvindex, boolean interferometry) throws SourceNeverVisibleException, InvalidFrequencyException {
        double brightTemp;
        double sensitivity = ExposureTimeCalculator.pointSourceSensitivity(exposureTimeSec, frequencyGHz, bandwidthGHz, corrEfficiency, decDeg, numberAntennas, antennaDiameter, latitudeDeg, wvindex, interferometry);
        if (interferometry) {
            brightTemp = ExposureTimeCalculator.toBrightnessTemp(sensitivity, frequencyGHz, resolution);
        } else {
            BasicAntenna ant = antennaDiameter == 7.0 ? BasicAntenna.ANTENNA_7M : BasicAntenna.ANTENNA_12M;
            double beamsize = ant.getBeamSize(frequencyGHz);
            brightTemp = ExposureTimeCalculator.toBrightnessTemp(sensitivity, frequencyGHz, beamsize);
        }
        return brightTemp;
    }

    public static double toFluxDensity(double brightnessTempK, double frequencyGHz, double beamArcsec) {
        double wavelengthM = 2.99792458E8 / (frequencyGHz * 1.0E9);
        double angle = Math.PI * beamArcsec / 3600.0 / 180.0;
        double omega = Math.PI * angle * angle / 4.0 / Math.log(2.0);
        double result = brightnessTempK * omega * 2.0 * 1380.0000000000002 / (wavelengthM * wavelengthM);
        return result;
    }

    public static double toBrightnessTemp(double sensitivityJy, double frequencyGHz, double beamArcsec) {
        double wavelengthM = 2.99792458E8 / (frequencyGHz * 1.0E9);
        double result = sensitivityJy * wavelengthM * wavelengthM / 2760.0000000000005;
        double angle = Math.PI * beamArcsec / 3600.0 / 180.0;
        double omega = Math.PI * angle * angle / 4.0 / Math.log(2.0);
        return result /= omega;
    }

    public static double antennaEfficiency(double diameter, double frequencyGHz) {
        double antRadius = diameter / 2.0;
        double antArea = Math.PI * antRadius * antRadius;
        double ae = 2760.0000000000005 / antArea;
        double appertureEfficiency = ExposureTimeCalculator.appertureEfficiency(diameter, frequencyGHz);
        return ae / appertureEfficiency;
    }

    public static double appertureEfficiency(double diameter, double frequencyGHz) {
        double sigma = diameter < 10.0 ? 20.0 : 25.0;
        double lambda = 299792.458 / frequencyGHz;
        double arg = Math.PI * 4 * sigma / lambda;
        double ret = ExposureTimeCalculator.illuminationEfficiency() * Math.exp(-arg * arg);
        return ret;
    }

    public static double appertureEfficiency(double frequencyGHz) {
        return ExposureTimeCalculator.appertureEfficiency(12.0, frequencyGHz);
    }

    public static void checkSourceVisible(double decDeg, double latitudeDeg, String siteName) throws SourceNeverVisibleException {
        if (Math.abs(decDeg - latitudeDeg) >= 90.0) {
            String msg;
            try {
                msg = "Source at declination " + Convert.degToDDMMSS(decDeg) + " is not visible";
                if (siteName != null) {
                    msg = msg + " to " + siteName;
                }
                msg = msg + ".";
            }
            catch (OutOfRangeException e) {
                msg = "The source is not visible.";
            }
            catch (InvalidCoordException e) {
                msg = "The source is not visible.";
            }
            throw new SourceNeverVisibleException(msg);
        }
    }

    public static void checkSourceVisible(double decDeg, double latitudeDeg) throws SourceNeverVisibleException {
        ExposureTimeCalculator.checkSourceVisible(decDeg, latitudeDeg, null);
    }

    public static double getTsys(double decDeg, double latitudeDeg, double frequencyGHz, int wvindex) throws InvalidFrequencyException, SourceNeverVisibleException {
        AtmosphereTable atbl = AtmosphereTable.getInstance();
        ExposureTimeCalculator.checkSourceVisible(decDeg, latitudeDeg, null);
        double latitudeRad = Math.toRadians(latitudeDeg);
        double decRad = Math.toRadians(decDeg);
        double sinDec = Math.sin(decRad);
        double sinLat = Math.sin(latitudeRad);
        double cosDec = Math.cos(decRad);
        double cosLat = Math.cos(latitudeRad);
        double sinAltitude = sinDec * sinLat + cosDec * cosLat;
        double Airmass = 1.0 / sinAltitude;
        double Tamb = 270.0;
        double eta_feed = 0.95;
        double Trx = ReceiverTemperature.getReceiverTemperature(frequencyGHz);
        double gr = BasicReceiverBand.getReceiverBand(frequencyGHz).getSidebandGainRatio();
        AtmosphereTable.Data tmp = AtmosphereTable.lookup((float)frequencyGHz, wvindex);
        if (tmp == null) {
            return 1.0E9;
        }
        double Tsky_atm = tmp.getTsky();
        double tau_zero = tmp.getTau();
        double f = Math.exp(tau_zero * Airmass);
        double Tcmb = 2.725;
        double Tsky_atmp = ExposureTimeCalculator.planck(frequencyGHz, Tsky_atm);
        Tamb = ExposureTimeCalculator.planck(frequencyGHz, Tamb);
        Tcmb = ExposureTimeCalculator.planck(frequencyGHz, Tcmb);
        double Tsky_z = ExposureTimeCalculator.tskyElevationCorrection(Tsky_atmp, tau_zero, decDeg, latitudeDeg);
        double Tsys = Trx + Tsky_z * eta_feed + Tamb * (1.0 - eta_feed);
        Tsys = f / eta_feed * Tsys;
        return Tsys *= 1.0 + gr;
    }

    public static double tskyElevationCorrection(double tsky_atm, double tau_zero, double decDeg, double latitudeDeg) {
        double zenithrad = Math.toRadians(Math.abs(decDeg - latitudeDeg));
        double secZenith = 1.0 / Math.cos(zenithrad);
        double tsky_z = tsky_atm * (1.0 - Math.exp(-tau_zero * secZenith)) / (1.0 - Math.exp(-tau_zero));
        return tsky_z;
    }

    public static double planck(double frequencyGHz, double temp) {
        double k = 1.38E-23;
        double f = frequencyGHz * 1.0E9;
        double arg0 = 6.626E-34 * f / 1.38E-23;
        double ret = arg0 / (Math.exp(arg0 / temp) - 1.0);
        return ret;
    }

    private static double illuminationEfficiency() {
        return 0.72;
    }

    public static double mainBeamEfficiency(double frequencyGHz) {
        return 1.0 * ExposureTimeCalculator.appertureEfficiency(frequencyGHz);
    }

    private static double instrumentDecor() {
        return 1.0;
    }

    private static double atmosphericDecor() {
        return 1.0;
    }
}

