/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.lookup;

import alma.common.sensitivitycalculatorcore.capabilities.BasicAlmaArrayCapabilities;
import alma.common.sensitivitycalculatorcore.enumerations.ReceiverType;
import alma.common.sensitivitycalculatorcore.utils.FrequencyRange;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;

public final class BasicReceiverBand
implements Comparable<Object> {
    static final String RECEIVERBAND_ALMA_RB_01 = "ALMA_RB_01";
    static final String RECEIVERBAND_ALMA_RB_02 = "ALMA_RB_02";
    static final String RECEIVERBAND_ALMA_RB_03 = "ALMA_RB_03";
    static final String RECEIVERBAND_ALMA_RB_04 = "ALMA_RB_04";
    static final String RECEIVERBAND_ALMA_RB_05 = "ALMA_RB_05";
    static final String RECEIVERBAND_ALMA_RB_06 = "ALMA_RB_06";
    static final String RECEIVERBAND_ALMA_RB_07 = "ALMA_RB_07";
    static final String RECEIVERBAND_ALMA_RB_08 = "ALMA_RB_08";
    static final String RECEIVERBAND_ALMA_RB_09 = "ALMA_RB_09";
    static final String RECEIVERBAND_ALMA_RB_10 = "ALMA_RB_10";
    static final String RECEIVERTYPE_DSB = "DSB";
    static final String RECEIVERTYPE_SSB = "SSB";
    static final String RECEIVERTYPE_TSB = "TSB";
    private static final BasicReceiverBand[] ALLBANDS = new BasicReceiverBand[]{new BasicReceiverBand(1, "SSB", 35.0, 52.0, 4.0, 12.0, 1, 0.0, false, true, "ALMA_RB_01"), new BasicReceiverBand(2, "SSB", 67.0, 84.0, 4.0, 12.0, 1, 0.0, true, false, "ALMA_RB_02"), new BasicReceiverBand(3, "TSB", 84.0, 116.0, 4.0, 8.0, 1, "ALMA_RB_03"), new BasicReceiverBand(4, "TSB", 125.0, 163.0, 4.0, 8.0, 2, "ALMA_RB_04"), new BasicReceiverBand(5, "TSB", 163.0, 211.0, 4.0, 8.0, 2, "ALMA_RB_05"), new BasicReceiverBand(6, "TSB", 211.0, 275.0, 5.0, 10.0, 3, "ALMA_RB_06"), new BasicReceiverBand(7, "TSB", 275.0, 373.0, 4.0, 8.0, 3, "ALMA_RB_07"), new BasicReceiverBand(8, "TSB", 385.0, 500.0, 4.0, 8.0, 5, "ALMA_RB_08"), new BasicReceiverBand(9, "DSB", 602.0, 720.0, 4.0, 12.0, 5, 1.0, "ALMA_RB_09"), new BasicReceiverBand(10, "DSB", 787.0, 950.0, 4.0, 12.0, 9, 1.0, "ALMA_RB_10")};
    public static final BasicReceiverBand ILLEGAL_RECEIVER = new BasicReceiverBand(0, "N/A", 0.0, 0.0, 0.0, 0.0, 0, "Receiver not specified");
    private int number;
    private String type;
    private String name;
    private double rfMax;
    private double rfMin;
    private double ifMax;
    private double ifMin;
    private int nCold;
    private boolean hasLower;
    private boolean hasUpper;
    private double sidebandGainRatio;

    private static BasicReceiverBand[] getAvailableBands() {
        BasicAlmaArrayCapabilities ac = BasicAlmaArrayCapabilities.getInstance();
        String[] bands = ac.getAvailableReceiverBands();
        BasicReceiverBand[] AVAILABLEBANDS = new BasicReceiverBand[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            for (int j = 0; j < ALLBANDS.length; ++j) {
                if (!BasicReceiverBand.ALLBANDS[j].name.equals(bands[i])) continue;
                AVAILABLEBANDS[i] = ALLBANDS[j];
            }
        }
        return AVAILABLEBANDS;
    }

    private BasicReceiverBand(int number, String type, double minRF, double maxRF, double minIF, double maxIF, int cold, double sgratio, boolean hasLower, boolean hasUpper, String nameVal) {
        this.number = number;
        this.type = type;
        this.rfMin = minRF;
        this.rfMax = maxRF;
        this.ifMin = minIF;
        this.ifMax = maxIF;
        this.nCold = cold;
        this.sidebandGainRatio = sgratio;
        this.hasLower = hasLower;
        this.hasUpper = hasUpper;
        this.name = nameVal;
    }

    private BasicReceiverBand(int number, String type, double minRF, double maxRF, double minIF, double maxIF, int cold, String nameVal) {
        this(number, type, minRF, maxRF, minIF, maxIF, cold, 0.0, true, true, nameVal);
    }

    private BasicReceiverBand(int number, String type, double minRF, double maxRF, double minIF, double maxIF, int cold, double sgratio, String nameVal) {
        this(number, type, minRF, maxRF, minIF, maxIF, cold, sgratio, true, true, nameVal);
    }

    public static String getAllowedFrequencyRangesDesc() {
        StringBuffer sb = new StringBuffer();
        int perLine = 4;
        sb.append("Allowed frequency ranges are (in GHz):\n");
        for (int i = 0; i < BasicReceiverBand.getAvailableBands().length; ++i) {
            sb.append(BasicReceiverBand.getAvailableBands()[i].toString());
            if ((i + 1) % 4 == 0) {
                sb.append("\n");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getAllowedFrequencyRangesDesc(boolean html) {
        String desc = BasicReceiverBand.getAllowedFrequencyRangesDesc();
        if (!html) {
            return desc;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(desc.replaceAll("\n", "<br>"));
        sb.append("</html>");
        return sb.toString();
    }

    public static String[] getKnownReceiverBandNames() {
        String[] ret = new String[BasicReceiverBand.getAvailableBands().length];
        for (int i = 0; i < BasicReceiverBand.getAvailableBands().length; ++i) {
            ret[i] = BasicReceiverBand.getAvailableBands()[i].getName();
        }
        return ret;
    }

    public static Collection<BasicReceiverBand> getKnownReceiverBands() {
        Vector<BasicReceiverBand> result = new Vector<BasicReceiverBand>(BasicReceiverBand.getAvailableBands().length);
        for (BasicReceiverBand rb : BasicReceiverBand.getAvailableBands()) {
            result.add(rb);
        }
        return result;
    }

    public static Collection<BasicReceiverBand> getFullReceiverBands() {
        TreeSet<BasicReceiverBand> result = new TreeSet<BasicReceiverBand>();
        for (BasicReceiverBand rb : ALLBANDS) {
            result.add(rb);
        }
        return result;
    }

    public static int getFullNumberOfReceiverBands() {
        return ALLBANDS.length;
    }

    public static BasicReceiverBand getReceiverBand(String name) {
        for (int i = 0; i < BasicReceiverBand.getAvailableBands().length; ++i) {
            BasicReceiverBand rb = BasicReceiverBand.getAvailableBands()[i];
            if (!rb.getName().equals(name)) continue;
            return rb;
        }
        return null;
    }

    public static String getReceiverBandName(double f) throws IllegalArgumentException {
        for (int i = 0; i < BasicReceiverBand.getAvailableBands().length; ++i) {
            BasicReceiverBand band = BasicReceiverBand.getAvailableBands()[i];
            if (!(band.getRFMin() <= f) || !(f <= band.getRFMax())) continue;
            return band.getName();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Unknown frequency: ").append(f).append("\n").append(BasicReceiverBand.getAllowedFrequencyRangesDesc());
        throw new IllegalArgumentException(sb.toString());
    }

    public static BasicReceiverBand getReceiverBand(double frequencyGHz) throws IllegalArgumentException {
        for (int i = 0; i < BasicReceiverBand.getAvailableBands().length; ++i) {
            BasicReceiverBand band = BasicReceiverBand.getAvailableBands()[i];
            if (!(band.getRFMin() <= frequencyGHz) || !(frequencyGHz <= band.getRFMax())) continue;
            return band;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Unknown frequency: ").append(frequencyGHz).append("\n").append(BasicReceiverBand.getAllowedFrequencyRangesDesc());
        throw new IllegalArgumentException(sb.toString());
    }

    public static BasicReceiverBand getReceiverBand(int number) {
        for (BasicReceiverBand rb : BasicReceiverBand.getKnownReceiverBands()) {
            if (rb.getNumber() != number) continue;
            return rb;
        }
        return null;
    }

    public int getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public ReceiverType getReceiverType() {
        return ReceiverType.valueOf(this.type);
    }

    public double getRFMax() {
        return this.rfMax;
    }

    public double getRFMin() {
        return this.rfMin;
    }

    public double getIFMax() {
        return this.ifMax;
    }

    public double getIFMin() {
        return this.ifMin;
    }

    public double getLOMax() {
        if (this.number == 2) {
            return this.getRFMax() + this.getIFMin();
        }
        return this.getRFMax() - this.getIFMax();
    }

    public double getLOMin() {
        if (this.number == 1) {
            return this.getRFMin() - this.getIFMin();
        }
        return this.getRFMin() + this.getIFMax();
    }

    public double getSidebandGainRatio() {
        return this.sidebandGainRatio;
    }

    public int getNCold() {
        return this.nCold;
    }

    public boolean hasLower() {
        return this.hasLower;
    }

    public boolean hasUpper() {
        return this.hasUpper;
    }

    public String getName() {
        return this.name;
    }

    public FrequencyRange getRFRange() {
        return new FrequencyRange(this.rfMin, this.rfMax);
    }

    public FrequencyRange getIFRange() {
        return new FrequencyRange(this.ifMin, this.ifMax);
    }

    public boolean isValidFrequency(double frequency) {
        return frequency <= this.getRFMax() && frequency >= this.getRFMin();
    }

    @Override
    public int compareTo(Object o) {
        BasicReceiverBand other = (BasicReceiverBand)o;
        return new Integer(this.number).compareTo(other.number);
    }

    public double getSuitabilityRating(double frequency) {
        double delta1 = frequency - this.getRFMin();
        double delta2 = this.getRFMax() - frequency;
        return Math.min(delta1, delta2);
    }

    public String toString() {
        return this.getRFRangeString();
    }

    public String toSimpleString() {
        return String.format("Band %02d", this.number);
    }

    public String getRFRangeString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName()).append(" [").append(this.getRFMin()).append("-").append(this.getRFMax()).append("]");
        return sb.toString();
    }

    public String getIFRangeString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName()).append(" [").append(this.getIFMin()).append("-").append(this.getIFMax()).append("]");
        return sb.toString();
    }
}

