/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.lookup;

import alma.common.sensitivitycalculatorcore.exceptions.InvalidFrequencyException;
import alma.common.sensitivitycalculatorcore.lookup.BasicReceiverBand;
import java.util.HashMap;
import java.util.Map;

public class ReceiverTemperature {
    private static Map<BasicReceiverBand, ReceiverTemperature> map = new HashMap<BasicReceiverBand, ReceiverTemperature>();
    private double baseTemperatureK;

    private ReceiverTemperature(double baseTemperatureK, double sidebandGainRatio) {
        this.baseTemperatureK = baseTemperatureK;
    }

    private ReceiverTemperature(double baseTemperatureK) {
        this(baseTemperatureK, 0.0);
    }

    private double getReceiverTemperatureK() {
        return this.baseTemperatureK;
    }

    public static double getReceiverTemperature(double frequencyGHz) throws InvalidFrequencyException {
        try {
            BasicReceiverBand rx = BasicReceiverBand.getReceiverBand(frequencyGHz);
            ReceiverTemperature t = map.get(rx);
            return t.getReceiverTemperatureK();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFrequencyException(frequencyGHz);
        }
    }

    static {
        map.put(BasicReceiverBand.getReceiverBand(1), new ReceiverTemperature(25.0));
        map.put(BasicReceiverBand.getReceiverBand(2), new ReceiverTemperature(30.0));
        map.put(BasicReceiverBand.getReceiverBand(3), new ReceiverTemperature(45.0));
        map.put(BasicReceiverBand.getReceiverBand(4), new ReceiverTemperature(51.0));
        map.put(BasicReceiverBand.getReceiverBand(5), new ReceiverTemperature(55.0));
        map.put(BasicReceiverBand.getReceiverBand(6), new ReceiverTemperature(55.0));
        map.put(BasicReceiverBand.getReceiverBand(7), new ReceiverTemperature(75.0));
        map.put(BasicReceiverBand.getReceiverBand(8), new ReceiverTemperature(150.0));
        map.put(BasicReceiverBand.getReceiverBand(9), new ReceiverTemperature(110.0));
        map.put(BasicReceiverBand.getReceiverBand(10), new ReceiverTemperature(230.0));
    }
}

