/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sensitivitycalculatorcore.lookup;

import alma.common.sensitivitycalculatorcore.calc.ExposureTimeCalculator;
import alma.common.sensitivitycalculatorcore.exceptions.InvalidFrequencyException;
import alma.common.sensitivitycalculatorcore.exceptions.SourceNeverVisibleException;
import alma.common.sensitivitycalculatorcore.lookup.AtmosphereTable;
import alma.common.sensitivitycalculatorcore.lookup.BasicReceiverBand;
import java.util.HashMap;
import java.util.Map;

public class WaterVaporColumns {
    public static final String CHOICE_AUTO = "Automatic Choice";
    public static final String CHOICE_MANUAL = "Manual Choice";
    public static final int WORST_WVINDEX = 6;
    private static final double timeIncreaseFactor = 2.0;
    private static Map<BasicReceiverBand, Integer> wvmap = new HashMap<BasicReceiverBand, Integer>();

    public static int wvindexSelector(BasicReceiverBand rx) {
        Integer ret = wvmap.get(rx);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown ReceiverBand : " + rx);
        }
        return ret;
    }

    public static int wvindexSelector(double frequencyGHz, double declinationDeg, double obsLat) {
        int i;
        double[] time = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] relTime = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double minTime = Double.MAX_VALUE;
        int useIndex = -1;
        for (i = 0; i < AtmosphereTable.WV_MAP.length; ++i) {
            try {
                time[i] = ExposureTimeCalculator.pointSourceExposureTime(1.0, frequencyGHz, 15.0, 1.0, declinationDeg, 50, 12.0, obsLat, i, true);
                relTime[i] = time[i] / time[0];
            }
            catch (InvalidFrequencyException invalidFrequencyException) {
            }
            catch (SourceNeverVisibleException sourceNeverVisibleException) {
                // empty catch block
            }
            if (!(time[i] < minTime)) continue;
            minTime = time[i];
        }
        for (i = 0; i < AtmosphereTable.WV_MAP.length; ++i) {
            if (!(relTime[i] > 2.0)) continue;
            useIndex = i - 1;
            break;
        }
        if (useIndex == -1) {
            useIndex = AtmosphereTable.WV_MAP.length - 1;
        }
        return useIndex;
    }

    public static int wvindexSelectorUsingLength(double length) {
        double[] octiles = AtmosphereTable.WV_MAP_VALUES;
        int index = 0;
        for (int i = 0; i < AtmosphereTable.WV_MAP_VALUES.length; ++i) {
            if (!(octiles[i] <= length) || !(octiles[index] < octiles[i])) continue;
            index = i;
        }
        return index;
    }

    public static String getSelectorDescriptions(boolean inHtml) {
        String newline = inHtml ? "<BR>" : "";
        String lt = inHtml ? "&nbsp;&lt;&nbsp;" : " < ";
        String b1min = "35";
        String b4max = "163";
        String b5min = "163";
        String b6max = "275";
        String b7min = "275";
        String b8max = "500";
        String b9min = "602";
        String b10max = "950";
        StringBuilder sb = new StringBuilder();
        sb.append(WaterVaporColumns.getWVIndexLabel(5)).append(" for Reciever Band 1 to 4 (").append(b1min).append("GHz").append(lt).append("freq").append(lt).append(b4max).append("GHz)").append(newline);
        sb.append(WaterVaporColumns.getWVIndexLabel(4)).append(" for Reciever Band 5 and 6 (").append(b5min).append("GHz").append(lt).append("freq").append(lt).append(b6max).append("GHz)").append(newline);
        sb.append(WaterVaporColumns.getWVIndexLabel(3)).append(" for Reciever Band 7 and 8 (").append(b7min).append("GHz").append(lt).append("freq").append(lt).append(b8max).append("GHz)").append(newline);
        sb.append(WaterVaporColumns.getWVIndexLabel(1)).append(" for Reciever Band 9 and 10 (").append(b9min).append("GHz").append(lt).append("freq").append(lt).append(b10max).append("GHz)").append(newline);
        return sb.toString();
    }

    public static int wvindexSelector(String label) {
        for (int i = 0; i < AtmosphereTable.WV_MAP.length; ++i) {
            if (!AtmosphereTable.WV_MAP[i].equals(label)) continue;
            return i;
        }
        return -1;
    }

    public static String getWVIndexLabel(int index) {
        if (index < 0) {
            return CHOICE_AUTO;
        }
        return AtmosphereTable.WV_MAP[index];
    }

    static {
        wvmap.put(BasicReceiverBand.getReceiverBand(1), 5);
        wvmap.put(BasicReceiverBand.getReceiverBand(2), 5);
        wvmap.put(BasicReceiverBand.getReceiverBand(3), 5);
        wvmap.put(BasicReceiverBand.getReceiverBand(4), 5);
        wvmap.put(BasicReceiverBand.getReceiverBand(5), 4);
        wvmap.put(BasicReceiverBand.getReceiverBand(6), 4);
        wvmap.put(BasicReceiverBand.getReceiverBand(7), 3);
        wvmap.put(BasicReceiverBand.getReceiverBand(8), 3);
        wvmap.put(BasicReceiverBand.getReceiverBand(9), 1);
        wvmap.put(BasicReceiverBand.getReceiverBand(10), 1);
    }
}

