/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Logger;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.ColFitsStarTable;
import uk.ac.starlink.fits.ColumnStore;
import uk.ac.starlink.fits.FileColumnStore;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class ColFitsTableSerializer
implements FitsTableSerializer {
    private final ColumnStore[] colStores_;
    private final String[] colids_;
    private final int ncol_;
    private final long nrow_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColFitsTableSerializer(StarTable table) throws IOException {
        this.ncol_ = table.getColumnCount();
        this.colStores_ = new ColumnStore[this.ncol_];
        this.colids_ = new String[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            this.colids_[icol] = info.toString();
            this.colStores_[icol] = FileColumnStore.createColumnStore(info);
            if (this.colStores_[icol] != null) continue;
            logger_.warning("Can't serialize column " + info);
        }
        boolean ok = false;
        RowSequence rseq = table.getRowSequence();
        try {
            long lrow = 0L;
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < this.ncol_; ++icol) {
                    ColumnStore colStore = this.colStores_[icol];
                    if (colStore == null) continue;
                    colStore.storeValue(row[icol]);
                }
                ++lrow;
            }
            this.nrow_ = lrow;
            ok = true;
        }
        finally {
            rseq.close();
            if (!ok) {
                for (int icol = 0; icol < this.ncol_; ++icol) {
                    if (this.colStores_[icol] == null) continue;
                    this.colStores_[icol].dispose();
                }
            }
        }
        if (!$assertionsDisabled && !ok) {
            throw new AssertionError();
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            if (this.colStores_[icol] == null || this.colStores_[icol] == null) continue;
            this.colStores_[icol].endStores();
        }
    }

    public Header getHeader() throws HeaderCardException {
        long size = 0L;
        int nUseCol = 0;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnStore colStore = this.colStores_[icol];
            if (colStore == null) continue;
            ++nUseCol;
            size += colStore.getDataLength();
        }
        Header hdr = new Header();
        hdr.addValue("XTENSION", "BINTABLE", "binary table extension");
        hdr.addValue("BITPIX", 8L, "8-bit bytes");
        hdr.addValue("NAXIS", 2L, "2-dimensional table");
        hdr.addValue("NAXIS1", size, "width of single row in bytes");
        hdr.addValue("NAXIS2", 1L, "single-row table");
        hdr.addValue("PCOUNT", 0L, "size of special data area");
        hdr.addValue("GCOUNT", 1L, "one data group");
        hdr.addValue("TFIELDS", nUseCol, "number of columns");
        int jcol = 0;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnStore colStore = this.colStores_[icol];
            if (colStore == null) continue;
            colStore.addHeaderInfo(hdr, ++jcol);
        }
        return hdr;
    }

    public void writeData(DataOutput out) throws IOException {
        long size = 0L;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            if (this.colStores_[icol] == null) continue;
            logger_.info("Writing column " + (icol + 1) + "/" + this.ncol_ + ": " + this.colids_[icol]);
            ColumnStore colStore = this.colStores_[icol];
            colStore.streamData(out);
            size += colStore.getDataLength();
            colStore.dispose();
        }
        int over = (int)(size % 2880L);
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public char getFormatChar(int icol) {
        ColumnStore colStore = this.colStores_[icol];
        if (colStore != null) {
            String tform = ColFitsTableSerializer.getCardValue(colStore, "TFORM").trim();
            return tform.charAt(tform.length() - 1);
        }
        return '\u0000';
    }

    public int[] getDimensions(int icol) {
        ColumnStore colStore = this.colStores_[icol];
        if (colStore != null) {
            long[] tdims = ColFitsStarTable.parseTdim(ColFitsTableSerializer.getCardValue(colStore, "TDIM"));
            int[] dims = new int[tdims.length - 1];
            for (int i = 0; i < tdims.length - 1; ++i) {
                dims[i] = Tables.checkedLongToInt(tdims[i]);
            }
            return dims;
        }
        return null;
    }

    public String getBadValue(int icol) {
        String tnull;
        ColumnStore colStore = this.colStores_[icol];
        if (colStore != null && (tnull = ColFitsTableSerializer.getCardValue(colStore, "TNULL")) != null && tnull.trim().length() > 0) {
            return tnull;
        }
        return null;
    }

    private static String getCardValue(ColumnStore colStore, String tcard) {
        Header hdr = new Header();
        try {
            int icol = 99;
            colStore.addHeaderInfo(hdr, icol);
            String key = tcard + icol;
            return hdr.containsKey(key) ? hdr.findCard(key).getValue().trim() : null;
        }
        catch (HeaderCardException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        $assertionsDisabled = !ColFitsTableSerializer.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.fits");
    }
}

