/*
 * Decompiled with CFR 0.152.
 */
package com.sunsetbrew.csv4180;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class CSVReader
extends BufferedReader {
    private boolean moreFieldsOnLine = true;
    private boolean eof = false;
    private final StringBuffer buffer = new StringBuffer();

    public CSVReader(Reader in) {
        super(in);
    }

    public CSVReader(Reader in, int sz) {
        super(in, sz);
    }

    public boolean hasMoreFieldsOnLine() {
        return this.moreFieldsOnLine;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void readFields(ArrayList<String> fields) throws IOException {
        fields.clear();
        if (this.eof) {
            throw new EOFException();
        }
        do {
            fields.add(this.readField());
        } while (this.moreFieldsOnLine);
    }

    public String readField() throws IOException {
        int c;
        boolean UNQUOTED = false;
        boolean QUOTED = true;
        int QUOTEDPLUS = 2;
        int state = 0;
        if (this.eof) {
            throw new EOFException();
        }
        this.buffer.setLength(0);
        block11: while ((c = this.read()) >= 0) {
            if (state == 2) {
                switch (c) {
                    case 34: {
                        this.buffer.append('\"');
                        state = 1;
                        continue block11;
                    }
                    default: {
                        state = 0;
                    }
                }
            }
            if (state == 1) {
                switch (c) {
                    default: {
                        this.buffer.append((char)c);
                        break;
                    }
                    case 34: {
                        state = 2;
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case 34: {
                    state = 1;
                    break;
                }
                case 13: {
                    break;
                }
                case 10: 
                case 44: {
                    this.moreFieldsOnLine = c != 10;
                    return this.buffer.toString();
                }
                default: {
                    this.buffer.append((char)c);
                }
            }
        }
        this.eof = true;
        this.moreFieldsOnLine = false;
        return this.buffer.toString();
    }
}

