/*
 * Decompiled with CFR 0.152.
 */
package com.sunsetbrew.csv4180;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVWriter
extends BufferedWriter {
    private boolean newLine = true;
    private final StringBuffer tmpBuffer = new StringBuffer();
    private static Pattern escapePattern = Pattern.compile("(\")");
    private static Pattern specialCharsPattern = Pattern.compile("[,\r\n]");
    private boolean newWriter = true;

    public CSVWriter(Writer out) {
        super(out);
    }

    public CSVWriter(Writer out, int sz) {
        super(out, sz);
    }

    public void writeFields(ArrayList<String> fields) throws IOException {
        if (this.newWriter) {
            this.newWriter = false;
        } else {
            this.newLine();
        }
        Iterator<String> si = fields.iterator();
        while (si.hasNext()) {
            this.writeField(si.next());
        }
    }

    public void writeFields(String[] fields) throws IOException {
        if (this.newWriter) {
            this.newWriter = false;
        } else {
            this.newLine();
        }
        int i = 0;
        while (i < fields.length) {
            this.writeField(fields[i]);
            ++i;
        }
    }

    @Override
    public void newLine() throws IOException {
        this.newLine = true;
        super.newLine();
    }

    public void writeField(String field) throws IOException {
        if (this.newLine) {
            this.newLine = false;
        } else {
            this.write(44);
        }
        if (field == null || field.length() == 0) {
            return;
        }
        Matcher matcher = escapePattern.matcher(field);
        if (matcher.find()) {
            this.write(34);
            this.tmpBuffer.setLength(0);
            do {
                matcher.appendReplacement(this.tmpBuffer, "\"\"");
            } while (matcher.find());
            matcher.appendTail(this.tmpBuffer);
            this.write(this.tmpBuffer.toString());
            this.write(34);
            return;
        }
        matcher = specialCharsPattern.matcher(field);
        if (matcher.find()) {
            this.write(34);
            this.write(field);
            this.write(34);
            return;
        }
        this.append(field);
    }
}

