/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.SampUtils;

public abstract class SampMap
extends AbstractMap {
    private final Map baseMap_;
    public static final Map EMPTY = Collections.unmodifiableMap(new HashMap());
    static /* synthetic */ Class class$org$astrogrid$samp$SampMap;

    protected SampMap(String[] knownKeys) {
        final List<String> knownKeyList = Arrays.asList((String[])knownKeys.clone());
        this.baseMap_ = new TreeMap(new Comparator(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                int k1 = knownKeyList.indexOf(s1);
                int k2 = knownKeyList.indexOf(s2);
                if (k1 >= 0) {
                    if (k2 >= 0) {
                        return k1 - k2;
                    }
                    return -1;
                }
                if (k2 >= 0) {
                    if (!$assertionsDisabled && k1 >= 0) {
                        throw new AssertionError();
                    }
                    return 1;
                }
                boolean f1 = s1.startsWith("samp.");
                boolean f2 = s2.startsWith("samp.");
                if (f1 && !f2) {
                    return -1;
                }
                if (!f1 && f2) {
                    return 1;
                }
                return s1.compareTo(s2);
            }

            static {
                $assertionsDisabled = !(class$org$astrogrid$samp$SampMap == null ? (class$org$astrogrid$samp$SampMap = SampMap.class$("org.astrogrid.samp.SampMap")) : class$org$astrogrid$samp$SampMap).desiredAssertionStatus();
            }
        });
    }

    public Object put(Object key, Object value) {
        return this.baseMap_.put(key, value);
    }

    public Set entrySet() {
        return this.baseMap_.entrySet();
    }

    public void check() {
        SampUtils.checkMap(this);
    }

    public void checkHasKeys(String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (this.containsKey(key)) continue;
            throw new DataException("Required key " + key + " not present");
        }
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Map getMap(String key) {
        return (Map)this.get(key);
    }

    public List getList(String key) {
        return (List)this.get(key);
    }

    public URL getUrl(String key) {
        String loc = this.getString(key);
        if (loc == null) {
            return null;
        }
        try {
            return new URL(loc);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

