/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.client.TrackedClientSet;
import org.astrogrid.samp.gui.ClientListCellRenderer;
import org.astrogrid.samp.gui.ErrorDialog;
import org.astrogrid.samp.gui.HubView;
import org.astrogrid.samp.gui.IconBox;
import org.astrogrid.samp.gui.IconStore;
import org.astrogrid.samp.xmlrpc.HubMode;
import org.astrogrid.samp.xmlrpc.HubRunner;
import org.astrogrid.samp.xmlrpc.XmlRpcKit;

public class GuiHubConnector
extends HubConnector {
    private final ListModel clientListModel_ = (ListModelTrackedClientSet)this.getClientSet();
    private final List connectionListenerList_ = new ArrayList();
    private final Map updateMap_ = new WeakHashMap();
    private boolean wasConnected_;
    static ConnectionUpdate ENABLE_ACTION = new ConnectionUpdate(){

        public void setConnected(Object action, boolean isConnected) {
            ((Action)action).setEnabled(isConnected);
        }
    };
    static ConnectionUpdate DISABLE_ACTION = new ConnectionUpdate(){

        public void setConnected(Object action, boolean isConnected) {
            ((Action)action).setEnabled(!isConnected);
        }
    };
    static ConnectionUpdate REPAINT_COMPONENT = new ConnectionUpdate(){

        public void setConnected(Object comp, boolean isConnected) {
            ((Component)comp).repaint();
        }
    };
    static ConnectionUpdate ENABLE_COMPONENT = new ConnectionUpdate(){

        public void setConnected(Object comp, boolean isConnected) {
            ((Component)comp).setEnabled(isConnected);
        }
    };
    static /* synthetic */ Class class$org$astrogrid$samp$gui$GuiHubConnector;

    public GuiHubConnector(ClientProfile profile) {
        super(profile, new ListModelTrackedClientSet());
        this.addConnectionListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GuiHubConnector.this.updateConnectionState();
            }
        });
        this.updateConnectionState();
    }

    public HubConnection getConnection() throws SampException {
        HubConnection connection = super.getConnection();
        this.scheduleConnectionChange();
        return connection;
    }

    protected void disconnect() {
        super.disconnect();
        this.scheduleConnectionChange();
    }

    public void addConnectionListener(ChangeListener listener) {
        this.connectionListenerList_.add(listener);
    }

    public void removeConnectionListener(ChangeListener listener) {
        this.connectionListenerList_.remove(listener);
    }

    public ListModel getClientListModel() {
        return this.clientListModel_;
    }

    public ListCellRenderer createClientListCellRenderer() {
        return new ClientListCellRenderer();
    }

    public Action createRegisterAction() {
        RegisterAction regAct = new RegisterAction(true);
        this.registerUpdater(regAct, DISABLE_ACTION);
        return regAct;
    }

    public Action createUnregisterAction() {
        RegisterAction unregAct = new RegisterAction(false);
        this.registerUpdater(unregAct, ENABLE_ACTION);
        return unregAct;
    }

    public Action createToggleRegisterAction() {
        RegisterAction toggleRegAct = new RegisterAction();
        this.registerUpdater(toggleRegAct, new ConnectionUpdate(){

            public void setConnected(Object item, boolean isConnected) {
                ((RegisterAction)item).setSense(!isConnected);
            }
        });
        return toggleRegAct;
    }

    public Action createRegisterOrHubAction(final Component parent, Action[] hubStartActions) {
        Action[] actionArray;
        if (hubStartActions == null) {
            Action[] actionArray2 = new Action[2];
            actionArray2[0] = this.createHubAction(false, HubMode.NO_GUI);
            actionArray = actionArray2;
            actionArray2[1] = this.createHubAction(true, HubMode.CLIENT_GUI);
        } else {
            actionArray = hubStartActions;
        }
        final Action[] hubActs = actionArray;
        RegisterAction regAct = new RegisterAction(){

            protected void registerFailed() {
                String[] msg = new String[]{"No SAMP hub is running.", "You may start a hub if you wish."};
                ArrayList buttList = new ArrayList();
                Object[] options = new JButton[hubActs.length + 1];
                for (int i = 0; i < hubActs.length; ++i) {
                    options[i] = new JButton(hubActs[i]);
                }
                options[hubActs.length] = new JButton("Cancel");
                JDialog dialog = new JOptionPane(msg, 2, -1, null, options, null).createDialog(parent, "No Hub");
                ActionListener closeListener = new ActionListener(this, dialog){
                    private final /* synthetic */ JDialog val$dialog;
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$dialog = val$dialog;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        this.val$dialog.dispose();
                    }
                };
                for (int iopt = 0; iopt < options.length; ++iopt) {
                    ((AbstractButton)options[iopt]).addActionListener(closeListener);
                }
                dialog.show();
            }
        };
        this.registerUpdater(regAct, new ConnectionUpdate(){

            public void setConnected(Object item, boolean isConnected) {
                ((RegisterAction)item).setSense(!isConnected);
            }
        });
        return regAct;
    }

    public Action createShowMonitorAction() {
        return new MonitorAction();
    }

    public Action createHubAction(boolean external, HubMode hubMode) {
        return new HubAction(external, hubMode);
    }

    public JComponent createConnectionIndicator(final Icon onIcon, final Icon offIcon) {
        JLabel label = new JLabel(new Icon(){

            private Icon effIcon() {
                return GuiHubConnector.this.isConnected() ? onIcon : offIcon;
            }

            public int getIconWidth() {
                return this.effIcon().getIconWidth();
            }

            public int getIconHeight() {
                return this.effIcon().getIconHeight();
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                this.effIcon().paintIcon(c, g, x, y);
            }
        });
        this.registerUpdater(label, REPAINT_COMPONENT);
        return label;
    }

    public JComponent createConnectionIndicator() {
        return this.createConnectionIndicator(new ImageIcon(Client.class.getResource("images/connected-24.gif")), new ImageIcon(Client.class.getResource("images/disconnected-24.gif")));
    }

    public JComponent createClientBox(final boolean vertical, int iconSize) {
        final IconStore iconStore = new IconStore(IconStore.createMinimalIcon(iconSize));
        IconBox box = new IconBox(iconSize);
        box.setVertical(vertical);
        box.setBorder(GuiHubConnector.createBoxBorder());
        box.setModel(this.clientListModel_);
        box.setRenderer(new IconBox.CellRenderer(){

            public Icon getIcon(IconBox iconBox, Object value, int index) {
                return IconStore.scaleIcon(iconStore.getIcon((Client)value), iconBox.getTransverseSize(), 2.0, !vertical);
            }

            public String getToolTipText(IconBox iconBox, Object value, int index) {
                return ((Client)value).toString();
            }
        });
        Dimension boxSize = box.getPreferredSize();
        boxSize.width = 128;
        box.setPreferredSize(boxSize);
        this.registerUpdater(box, ENABLE_COMPONENT);
        return box;
    }

    public JComponent createMonitorPanel() {
        HubView view = new HubView();
        view.setClientListModel(this.getClientListModel());
        view.getClientList().setCellRenderer(this.createClientListCellRenderer());
        return view;
    }

    private void scheduleConnectionChange() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean isConnected = GuiHubConnector.this.isConnected();
                if (isConnected != GuiHubConnector.this.wasConnected_) {
                    GuiHubConnector.this.wasConnected_ = isConnected;
                    ChangeEvent evt = new ChangeEvent(GuiHubConnector.this);
                    Iterator it = GuiHubConnector.this.connectionListenerList_.iterator();
                    while (it.hasNext()) {
                        ((ChangeListener)it.next()).stateChanged(evt);
                    }
                }
            }
        });
    }

    private void updateConnectionState() {
        boolean isConn = this.isConnected();
        Iterator it = this.updateMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object item = entry.getKey();
            ConnectionUpdate update = (ConnectionUpdate)entry.getValue();
            update.setConnected(item, isConn);
        }
    }

    static Border createBoxBorder() {
        return BorderFactory.createCompoundBorder(new JTextField().getBorder(), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    void registerUpdater(Object item, ConnectionUpdate updater) {
        updater.setConnected(item, this.isConnected());
        this.updateMap_.put(item, updater);
    }

    private class HubAction
    extends AbstractAction {
        private final boolean external_;
        private final HubMode hubMode_;

        HubAction(boolean external, HubMode hubMode) {
            this.external_ = external;
            this.hubMode_ = hubMode;
            this.putValue("Name", "Start " + (external ? "external" : "internal") + " hub");
            this.putValue("ShortDescription", "Attempts to start up a SAMP hub" + (external ? " running independently of this application" : " running within this application"));
            this.setEnabled(!GuiHubConnector.this.isConnected());
            GuiHubConnector.this.registerUpdater(this, DISABLE_ACTION);
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                this.attemptRunHub();
            }
            catch (Exception e) {
                ErrorDialog.showError(null, "Hub Start Failed", e.getMessage(), e);
            }
            GuiHubConnector.this.setActive(true);
        }

        private void attemptRunHub() throws IOException {
            if (this.external_) {
                HubRunner.runExternalHub(this.hubMode_);
            } else {
                HubRunner.runHub(this.hubMode_, XmlRpcKit.getInstance());
            }
            GuiHubConnector.this.setActive(true);
        }
    }

    private class MonitorAction
    extends AbstractAction {
        private JFrame monitorWindow_;

        MonitorAction() {
            super("Show Hub Status");
            this.putValue("ShortDescription", "Display a window showing client applications registered with the SAMP hub");
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.monitorWindow_ == null) {
                this.monitorWindow_ = new JFrame("SAMP Status");
                this.monitorWindow_.getContentPane().add((Component)GuiHubConnector.this.createMonitorPanel(), "Center");
                this.monitorWindow_.pack();
            }
            this.monitorWindow_.setVisible(true);
        }
    }

    private class RegisterAction
    extends AbstractAction {
        public RegisterAction() {
        }

        public RegisterAction(boolean active) {
            this();
            this.setSense(active);
        }

        public void setSense(boolean active) {
            this.putValue("ActionCommandKey", active ? "REGISTER" : "UNREGISTER");
            this.putValue("Name", active ? "Register with Hub" : "Unregister from Hub");
            this.putValue("ShortDescription", active ? "Attempt to connect to SAMP hub" : "Disconnect from SAMP hub");
        }

        public void actionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if ("REGISTER".equals(cmd)) {
                GuiHubConnector.this.setActive(true);
                if (!GuiHubConnector.this.isConnected()) {
                    this.registerFailed();
                }
            } else if ("UNREGISTER".equals(cmd)) {
                GuiHubConnector.this.setActive(false);
            } else {
                throw new UnsupportedOperationException("Unknown action " + cmd);
            }
        }

        protected void registerFailed() {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private static class ListModelTrackedClientSet
    extends TrackedClientSet
    implements ListModel {
        private final List clientList_ = new ArrayList();
        private final List listenerList_ = new ArrayList();

        ListModelTrackedClientSet() {
        }

        public int getSize() {
            return this.clientList_.size();
        }

        public Object getElementAt(int index) {
            return this.clientList_.get(index);
        }

        public void addListDataListener(ListDataListener listener) {
            this.listenerList_.add(listener);
        }

        public void removeListDataListener(ListDataListener listener) {
            this.listenerList_.remove(listener);
        }

        public void addClient(Client client) {
            super.addClient(client);
            SwingUtilities.invokeLater(new Runnable(this, client){
                private final /* synthetic */ Client val$client;
                private final /* synthetic */ ListModelTrackedClientSet this$0;
                {
                    this.this$0 = this$0;
                    this.val$client = val$client;
                }

                public void run() {
                    int index = ListModelTrackedClientSet.access$300(this.this$0).size();
                    ListModelTrackedClientSet.access$300(this.this$0).add(this.val$client);
                    ListDataEvent evt = new ListDataEvent(this.this$0, 1, index, index);
                    Iterator<E> it = ListModelTrackedClientSet.access$400(this.this$0).iterator();
                    while (it.hasNext()) {
                        ((ListDataListener)it.next()).intervalAdded(evt);
                    }
                }
            });
        }

        public void removeClient(Client client) {
            super.removeClient(client);
            SwingUtilities.invokeLater(new Runnable(this, client){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ Client val$client;
                private final /* synthetic */ ListModelTrackedClientSet this$0;
                {
                    this.this$0 = this$0;
                    this.val$client = val$client;
                }

                public void run() {
                    int index = ListModelTrackedClientSet.access$300(this.this$0).indexOf(this.val$client);
                    if (!$assertionsDisabled && index < 0) {
                        throw new AssertionError();
                    }
                    if (index >= 0) {
                        ListModelTrackedClientSet.access$300(this.this$0).remove(index);
                        ListDataEvent evt = new ListDataEvent(this.this$0, 2, index, index);
                        Iterator<E> it = ListModelTrackedClientSet.access$400(this.this$0).iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).intervalRemoved(evt);
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$astrogrid$samp$gui$GuiHubConnector == null ? (class$org$astrogrid$samp$gui$GuiHubConnector = GuiHubConnector.class$("org.astrogrid.samp.gui.GuiHubConnector")) : class$org$astrogrid$samp$gui$GuiHubConnector).desiredAssertionStatus();
                }
            });
        }

        public void setClients(Client[] clients) {
            super.setClients(clients);
            SwingUtilities.invokeLater(new Runnable(this, clients){
                private final /* synthetic */ Client[] val$clients;
                private final /* synthetic */ ListModelTrackedClientSet this$0;
                {
                    this.this$0 = this$0;
                    this.val$clients = val$clients;
                }

                public void run() {
                    int oldSize = ListModelTrackedClientSet.access$300(this.this$0).size();
                    if (oldSize > 0) {
                        ListModelTrackedClientSet.access$300(this.this$0).clear();
                        ListDataEvent removeEvt = new ListDataEvent(this.this$0, 2, 0, oldSize - 1);
                        Iterator<E> it = ListModelTrackedClientSet.access$400(this.this$0).iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).intervalRemoved(removeEvt);
                        }
                    }
                    if (this.val$clients.length > 0) {
                        ListModelTrackedClientSet.access$300(this.this$0).addAll(Arrays.asList(this.val$clients));
                        int newSize = ListModelTrackedClientSet.access$300(this.this$0).size();
                        ListDataEvent addEvt = new ListDataEvent(this.this$0, 1, 0, newSize - 1);
                        Iterator<E> it = ListModelTrackedClientSet.access$400(this.this$0).iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).intervalAdded(addEvt);
                        }
                    }
                }
            });
        }

        public void updateClient(Client client) {
            super.updateClient(client);
            SwingUtilities.invokeLater(new Runnable(this, client){
                private final /* synthetic */ Client val$client;
                private final /* synthetic */ ListModelTrackedClientSet this$0;
                {
                    this.this$0 = this$0;
                    this.val$client = val$client;
                }

                public void run() {
                    int index = ListModelTrackedClientSet.access$300(this.this$0).indexOf(this.val$client);
                    if (index >= 0) {
                        ListDataEvent evt = new ListDataEvent(this.this$0, 0, index, index);
                        Iterator<E> it = ListModelTrackedClientSet.access$400(this.this$0).iterator();
                        while (it.hasNext()) {
                            ((ListDataListener)it.next()).contentsChanged(evt);
                        }
                    }
                }
            });
        }

        static /* synthetic */ List access$300(ListModelTrackedClientSet x0) {
            return x0.clientList_;
        }

        static /* synthetic */ List access$400(ListModelTrackedClientSet x0) {
            return x0.listenerList_;
        }
    }

    static interface ConnectionUpdate {
        public void setConnected(Object var1, boolean var2);
    }
}

